// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cdn.fluent.models.ProfileInner;
import com.azure.resourcemanager.cdn.fluent.models.ResourceUsageInner;
import com.azure.resourcemanager.cdn.fluent.models.SsoUriInner;
import com.azure.resourcemanager.cdn.fluent.models.SupportedOptimizationTypesListResultInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ProfilesClient. */
public interface ProfilesClient
    extends InnerSupportsGet<ProfileInner>, InnerSupportsListing<ProfileInner>, InnerSupportsDelete<Void> {
    /**
     * Lists all of the CDN profiles within an Azure subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list profiles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ProfileInner> listAsync();

    /**
     * Lists all of the CDN profiles within an Azure subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list profiles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProfileInner> list();

    /**
     * Lists all of the CDN profiles within an Azure subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list profiles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProfileInner> list(Context context);

    /**
     * Lists all of the CDN profiles within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list profiles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ProfileInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Lists all of the CDN profiles within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list profiles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProfileInner> listByResourceGroup(String resourceGroupName);

    /**
     * Lists all of the CDN profiles within a resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list profiles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProfileInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Gets a CDN profile with the specified profile name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a CDN profile with the specified profile name under the specified subscription and resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ProfileInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String profileName);

    /**
     * Gets a CDN profile with the specified profile name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a CDN profile with the specified profile name under the specified subscription and resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProfileInner> getByResourceGroupAsync(String resourceGroupName, String profileName);

    /**
     * Gets a CDN profile with the specified profile name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a CDN profile with the specified profile name under the specified subscription and resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProfileInner getByResourceGroup(String resourceGroupName, String profileName);

    /**
     * Gets a CDN profile with the specified profile name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a CDN profile with the specified profile name under the specified subscription and resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ProfileInner> getByResourceGroupWithResponse(
        String resourceGroupName, String profileName, Context context);

    /**
     * Creates a new CDN profile with a profile name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param profile CDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider
     *     and pricing tier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName, String profileName, ProfileInner profile);

    /**
     * Creates a new CDN profile with a profile name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param profile CDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider
     *     and pricing tier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ProfileInner>, ProfileInner> beginCreateAsync(
        String resourceGroupName, String profileName, ProfileInner profile);

    /**
     * Creates a new CDN profile with a profile name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param profile CDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider
     *     and pricing tier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ProfileInner>, ProfileInner> beginCreate(
        String resourceGroupName, String profileName, ProfileInner profile);

    /**
     * Creates a new CDN profile with a profile name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param profile CDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider
     *     and pricing tier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ProfileInner>, ProfileInner> beginCreate(
        String resourceGroupName, String profileName, ProfileInner profile, Context context);

    /**
     * Creates a new CDN profile with a profile name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param profile CDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider
     *     and pricing tier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProfileInner> createAsync(String resourceGroupName, String profileName, ProfileInner profile);

    /**
     * Creates a new CDN profile with a profile name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param profile CDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider
     *     and pricing tier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProfileInner create(String resourceGroupName, String profileName, ProfileInner profile);

    /**
     * Creates a new CDN profile with a profile name under the specified subscription and resource group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param profile CDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider
     *     and pricing tier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProfileInner create(String resourceGroupName, String profileName, ProfileInner profile, Context context);

    /**
     * Updates an existing CDN profile with the specified profile name under the specified subscription and resource
     * group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param tags Profile tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName, String profileName, Map<String, String> tags);

    /**
     * Updates an existing CDN profile with the specified profile name under the specified subscription and resource
     * group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param tags Profile tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ProfileInner>, ProfileInner> beginUpdateAsync(
        String resourceGroupName, String profileName, Map<String, String> tags);

    /**
     * Updates an existing CDN profile with the specified profile name under the specified subscription and resource
     * group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param tags Profile tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ProfileInner>, ProfileInner> beginUpdate(
        String resourceGroupName, String profileName, Map<String, String> tags);

    /**
     * Updates an existing CDN profile with the specified profile name under the specified subscription and resource
     * group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param tags Profile tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ProfileInner>, ProfileInner> beginUpdate(
        String resourceGroupName, String profileName, Map<String, String> tags, Context context);

    /**
     * Updates an existing CDN profile with the specified profile name under the specified subscription and resource
     * group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param tags Profile tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProfileInner> updateAsync(String resourceGroupName, String profileName, Map<String, String> tags);

    /**
     * Updates an existing CDN profile with the specified profile name under the specified subscription and resource
     * group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProfileInner> updateAsync(String resourceGroupName, String profileName);

    /**
     * Updates an existing CDN profile with the specified profile name under the specified subscription and resource
     * group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param tags Profile tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProfileInner update(String resourceGroupName, String profileName, Map<String, String> tags);

    /**
     * Updates an existing CDN profile with the specified profile name under the specified subscription and resource
     * group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProfileInner update(String resourceGroupName, String profileName);

    /**
     * Updates an existing CDN profile with the specified profile name under the specified subscription and resource
     * group.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param tags Profile tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
     *     pricing tier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProfileInner update(String resourceGroupName, String profileName, Map<String, String> tags, Context context);

    /**
     * Deletes an existing CDN profile with the specified parameters. Deleting a profile will result in the deletion of
     * all of the sub-resources including endpoints, origins and custom domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName);

    /**
     * Deletes an existing CDN profile with the specified parameters. Deleting a profile will result in the deletion of
     * all of the sub-resources including endpoints, origins and custom domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName);

    /**
     * Deletes an existing CDN profile with the specified parameters. Deleting a profile will result in the deletion of
     * all of the sub-resources including endpoints, origins and custom domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName);

    /**
     * Deletes an existing CDN profile with the specified parameters. Deleting a profile will result in the deletion of
     * all of the sub-resources including endpoints, origins and custom domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, Context context);

    /**
     * Deletes an existing CDN profile with the specified parameters. Deleting a profile will result in the deletion of
     * all of the sub-resources including endpoints, origins and custom domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String profileName);

    /**
     * Deletes an existing CDN profile with the specified parameters. Deleting a profile will result in the deletion of
     * all of the sub-resources including endpoints, origins and custom domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String profileName);

    /**
     * Deletes an existing CDN profile with the specified parameters. Deleting a profile will result in the deletion of
     * all of the sub-resources including endpoints, origins and custom domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String profileName, Context context);

    /**
     * Generates a dynamic SSO URI used to sign in to the CDN supplemental portal. Supplemental portal is used to
     * configure advanced feature capabilities that are not yet available in the Azure portal, such as core reports in a
     * standard profile; rules engine, advanced HTTP reports, and real-time stats and alerts in a premium profile. The
     * SSO URI changes approximately every 10 minutes.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the URI required to login to the supplemental portal from the Azure portal.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SsoUriInner>> generateSsoUriWithResponseAsync(String resourceGroupName, String profileName);

    /**
     * Generates a dynamic SSO URI used to sign in to the CDN supplemental portal. Supplemental portal is used to
     * configure advanced feature capabilities that are not yet available in the Azure portal, such as core reports in a
     * standard profile; rules engine, advanced HTTP reports, and real-time stats and alerts in a premium profile. The
     * SSO URI changes approximately every 10 minutes.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the URI required to login to the supplemental portal from the Azure portal.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SsoUriInner> generateSsoUriAsync(String resourceGroupName, String profileName);

    /**
     * Generates a dynamic SSO URI used to sign in to the CDN supplemental portal. Supplemental portal is used to
     * configure advanced feature capabilities that are not yet available in the Azure portal, such as core reports in a
     * standard profile; rules engine, advanced HTTP reports, and real-time stats and alerts in a premium profile. The
     * SSO URI changes approximately every 10 minutes.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the URI required to login to the supplemental portal from the Azure portal.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SsoUriInner generateSsoUri(String resourceGroupName, String profileName);

    /**
     * Generates a dynamic SSO URI used to sign in to the CDN supplemental portal. Supplemental portal is used to
     * configure advanced feature capabilities that are not yet available in the Azure portal, such as core reports in a
     * standard profile; rules engine, advanced HTTP reports, and real-time stats and alerts in a premium profile. The
     * SSO URI changes approximately every 10 minutes.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the URI required to login to the supplemental portal from the Azure portal.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SsoUriInner> generateSsoUriWithResponse(String resourceGroupName, String profileName, Context context);

    /**
     * Gets the supported optimization types for the current profile. A user can create an endpoint with an optimization
     * type from the listed values.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the supported optimization types for the current profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SupportedOptimizationTypesListResultInner>> listSupportedOptimizationTypesWithResponseAsync(
        String resourceGroupName, String profileName);

    /**
     * Gets the supported optimization types for the current profile. A user can create an endpoint with an optimization
     * type from the listed values.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the supported optimization types for the current profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SupportedOptimizationTypesListResultInner> listSupportedOptimizationTypesAsync(
        String resourceGroupName, String profileName);

    /**
     * Gets the supported optimization types for the current profile. A user can create an endpoint with an optimization
     * type from the listed values.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the supported optimization types for the current profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SupportedOptimizationTypesListResultInner listSupportedOptimizationTypes(
        String resourceGroupName, String profileName);

    /**
     * Gets the supported optimization types for the current profile. A user can create an endpoint with an optimization
     * type from the listed values.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the supported optimization types for the current profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SupportedOptimizationTypesListResultInner> listSupportedOptimizationTypesWithResponse(
        String resourceGroupName, String profileName, Context context);

    /**
     * Checks the quota and actual usage of endpoints under the given CDN profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check resource usage API.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ResourceUsageInner> listResourceUsageAsync(String resourceGroupName, String profileName);

    /**
     * Checks the quota and actual usage of endpoints under the given CDN profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check resource usage API.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ResourceUsageInner> listResourceUsage(String resourceGroupName, String profileName);

    /**
     * Checks the quota and actual usage of endpoints under the given CDN profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check resource usage API.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ResourceUsageInner> listResourceUsage(String resourceGroupName, String profileName, Context context);
}
