// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Defines the parameters for the Url Signing action. */
@Fluent
public final class UrlSigningActionParameters {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(UrlSigningActionParameters.class);

    /*
     * The @odata.type property.
     */
    @JsonProperty(value = "@odata.type")
    private UrlSigningActionParametersOdataType odataType;

    /*
     * Id reference of the key to be used to verify the hash and should be
     * defined in UrlSigningKeys
     */
    @JsonProperty(value = "keyId", required = true)
    private String keyId;

    /*
     * Algorithm to use for URL signing
     */
    @JsonProperty(value = "algorithm")
    private Algorithm algorithm;

    /*
     * Defines which query string parameters in the url to be considered for
     * expires, key id etc.
     */
    @JsonProperty(value = "parameterNameOverride")
    private List<UrlSigningParamIdentifier> parameterNameOverride;

    /*
     * Match values to match against. Supports CIDR ranges (both IPv4 and
     * IPv6).
     */
    @JsonProperty(value = "ipSubnets")
    private List<String> ipSubnets;

    /**
     * Get the odataType property: The @odata.type property.
     *
     * @return the odataType value.
     */
    public UrlSigningActionParametersOdataType odataType() {
        return this.odataType;
    }

    /**
     * Set the odataType property: The @odata.type property.
     *
     * @param odataType the odataType value to set.
     * @return the UrlSigningActionParameters object itself.
     */
    public UrlSigningActionParameters withOdataType(UrlSigningActionParametersOdataType odataType) {
        this.odataType = odataType;
        return this;
    }

    /**
     * Get the keyId property: Id reference of the key to be used to verify the hash and should be defined in
     * UrlSigningKeys.
     *
     * @return the keyId value.
     */
    public String keyId() {
        return this.keyId;
    }

    /**
     * Set the keyId property: Id reference of the key to be used to verify the hash and should be defined in
     * UrlSigningKeys.
     *
     * @param keyId the keyId value to set.
     * @return the UrlSigningActionParameters object itself.
     */
    public UrlSigningActionParameters withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    /**
     * Get the algorithm property: Algorithm to use for URL signing.
     *
     * @return the algorithm value.
     */
    public Algorithm algorithm() {
        return this.algorithm;
    }

    /**
     * Set the algorithm property: Algorithm to use for URL signing.
     *
     * @param algorithm the algorithm value to set.
     * @return the UrlSigningActionParameters object itself.
     */
    public UrlSigningActionParameters withAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    /**
     * Get the parameterNameOverride property: Defines which query string parameters in the url to be considered for
     * expires, key id etc.
     *
     * @return the parameterNameOverride value.
     */
    public List<UrlSigningParamIdentifier> parameterNameOverride() {
        return this.parameterNameOverride;
    }

    /**
     * Set the parameterNameOverride property: Defines which query string parameters in the url to be considered for
     * expires, key id etc.
     *
     * @param parameterNameOverride the parameterNameOverride value to set.
     * @return the UrlSigningActionParameters object itself.
     */
    public UrlSigningActionParameters withParameterNameOverride(List<UrlSigningParamIdentifier> parameterNameOverride) {
        this.parameterNameOverride = parameterNameOverride;
        return this;
    }

    /**
     * Get the ipSubnets property: Match values to match against. Supports CIDR ranges (both IPv4 and IPv6).
     *
     * @return the ipSubnets value.
     */
    public List<String> ipSubnets() {
        return this.ipSubnets;
    }

    /**
     * Set the ipSubnets property: Match values to match against. Supports CIDR ranges (both IPv4 and IPv6).
     *
     * @param ipSubnets the ipSubnets value to set.
     * @return the UrlSigningActionParameters object itself.
     */
    public UrlSigningActionParameters withIpSubnets(List<String> ipSubnets) {
        this.ipSubnets = ipSubnets;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyId() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property keyId in model UrlSigningActionParameters"));
        }
        if (parameterNameOverride() != null) {
            parameterNameOverride().forEach(e -> e.validate());
        }
    }
}
