// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Defines values for UrlSigningActionParametersOdataType. */
public enum UrlSigningActionParametersOdataType {
    /** Enum value #Microsoft.Azure.Cdn.Models.DeliveryRuleUrlSigningActionParameters. */
    MICROSOFT_AZURE_CDN_MODELS_DELIVERY_RULE_URL_SIGNING_ACTION_PARAMETERS(
        "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlSigningActionParameters");

    /** The actual serialized value for a UrlSigningActionParametersOdataType instance. */
    private final String value;

    UrlSigningActionParametersOdataType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a UrlSigningActionParametersOdataType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed UrlSigningActionParametersOdataType object, or null if unable to parse.
     */
    @JsonCreator
    public static UrlSigningActionParametersOdataType fromString(String value) {
        UrlSigningActionParametersOdataType[] items = UrlSigningActionParametersOdataType.values();
        for (UrlSigningActionParametersOdataType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
