// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Describes the gallery unique name. */
@Immutable
public final class GalleryIdentifier {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(GalleryIdentifier.class);

    /*
     * The unique name of the Shared Image Gallery. This name is generated
     * automatically by Azure.
     */
    @JsonProperty(value = "uniqueName", access = JsonProperty.Access.WRITE_ONLY)
    private String uniqueName;

    /**
     * Get the uniqueName property: The unique name of the Shared Image Gallery. This name is generated automatically by
     * Azure.
     *
     * @return the uniqueName value.
     */
    public String uniqueName() {
        return this.uniqueName;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
