/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.AvailabilitySetInner;
import com.azure.resourcemanager.compute.fluent.models.ProximityPlacementGroupInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineSizeInner;
import com.azure.resourcemanager.compute.implementation.ProximityPlacementGroupImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineSizeImpl;
import com.azure.resourcemanager.compute.models.AvailabilitySet;
import com.azure.resourcemanager.compute.models.AvailabilitySetSkuTypes;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroup;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroupType;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.VirtualMachineSize;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import reactor.core.publisher.Mono;

class AvailabilitySetImpl
extends GroupableResourceImpl<AvailabilitySet, AvailabilitySetInner, AvailabilitySetImpl, ComputeManager>
implements AvailabilitySet,
AvailabilitySet.Definition,
AvailabilitySet.Update {
    private Set<String> idOfVMsInSet;
    private String newProximityPlacementGroupName = null;
    private ProximityPlacementGroupType newProximityPlacementGroupType = null;

    AvailabilitySetImpl(String name, AvailabilitySetInner innerModel, ComputeManager computeManager) {
        super(name, (Resource)innerModel, (Manager)computeManager);
    }

    @Override
    public int updateDomainCount() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((AvailabilitySetInner)((Object)this.innerModel())).platformUpdateDomainCount());
    }

    @Override
    public int faultDomainCount() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((AvailabilitySetInner)((Object)this.innerModel())).platformFaultDomainCount());
    }

    @Override
    public AvailabilitySetSkuTypes sku() {
        if (((AvailabilitySetInner)((Object)this.innerModel())).sku() != null && ((AvailabilitySetInner)((Object)this.innerModel())).sku().name() != null) {
            return AvailabilitySetSkuTypes.fromString(((AvailabilitySetInner)((Object)this.innerModel())).sku().name());
        }
        return null;
    }

    @Override
    public Set<String> virtualMachineIds() {
        if (this.idOfVMsInSet == null) {
            this.idOfVMsInSet = new HashSet<String>();
            for (SubResource resource : ((AvailabilitySetInner)((Object)this.innerModel())).virtualMachines()) {
                this.idOfVMsInSet.add(resource.id());
            }
        }
        return Collections.unmodifiableSet(this.idOfVMsInSet);
    }

    @Override
    public ProximityPlacementGroup proximityPlacementGroup() {
        if (((AvailabilitySetInner)((Object)this.innerModel())).proximityPlacementGroup() == null) {
            return null;
        }
        ResourceId id = ResourceId.fromString((String)((AvailabilitySetInner)((Object)this.innerModel())).proximityPlacementGroup().id());
        ProximityPlacementGroupInner plgInner = ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getProximityPlacementGroups().getByResourceGroup(id.resourceGroupName(), id.name());
        if (plgInner == null) {
            return null;
        }
        return new ProximityPlacementGroupImpl(plgInner);
    }

    @Override
    public List<InstanceViewStatus> statuses() {
        return Collections.unmodifiableList(((AvailabilitySetInner)((Object)this.innerModel())).statuses());
    }

    @Override
    public PagedIterable<VirtualMachineSize> listVirtualMachineSizes() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getAvailabilitySets().listAvailableSizes(this.resourceGroupName(), this.name()).mapPage(virtualMachineSizeInner -> new VirtualMachineSizeImpl((VirtualMachineSizeInner)virtualMachineSizeInner));
    }

    public Mono<AvailabilitySet> refreshAsync() {
        return super.refreshAsync().map(availabilitySet -> {
            AvailabilitySetImpl impl = (AvailabilitySetImpl)availabilitySet;
            impl.idOfVMsInSet = null;
            return impl;
        });
    }

    protected Mono<AvailabilitySetInner> getInnerAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getAvailabilitySets().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public AvailabilitySetImpl withUpdateDomainCount(int updateDomainCount) {
        ((AvailabilitySetInner)((Object)this.innerModel())).withPlatformUpdateDomainCount(updateDomainCount);
        return this;
    }

    @Override
    public AvailabilitySetImpl withFaultDomainCount(int faultDomainCount) {
        ((AvailabilitySetInner)((Object)this.innerModel())).withPlatformFaultDomainCount(faultDomainCount);
        return this;
    }

    @Override
    public AvailabilitySetImpl withSku(AvailabilitySetSkuTypes skuType) {
        if (((AvailabilitySetInner)((Object)this.innerModel())).sku() == null) {
            ((AvailabilitySetInner)((Object)this.innerModel())).withSku(new Sku());
        }
        ((AvailabilitySetInner)((Object)this.innerModel())).sku().withName(skuType.toString());
        return this;
    }

    @Override
    public AvailabilitySetImpl withProximityPlacementGroup(String proximityPlacementGroupId) {
        ((AvailabilitySetInner)((Object)this.innerModel())).withProximityPlacementGroup(new SubResource().withId(proximityPlacementGroupId));
        this.newProximityPlacementGroupType = null;
        this.newProximityPlacementGroupName = null;
        return this;
    }

    @Override
    public AvailabilitySetImpl withNewProximityPlacementGroup(String proximityPlacementGroupName, ProximityPlacementGroupType type) {
        this.newProximityPlacementGroupName = proximityPlacementGroupName;
        this.newProximityPlacementGroupType = type;
        ((AvailabilitySetInner)((Object)this.innerModel())).withProximityPlacementGroup(null);
        return this;
    }

    @Override
    public AvailabilitySetImpl withoutProximityPlacementGroup() {
        ((AvailabilitySetInner)((Object)this.innerModel())).withProximityPlacementGroup(null);
        return this;
    }

    public Mono<AvailabilitySet> createResourceAsync() {
        AvailabilitySetImpl self = this;
        if (((AvailabilitySetInner)((Object)this.innerModel())).platformFaultDomainCount() == null) {
            ((AvailabilitySetInner)((Object)this.innerModel())).withPlatformFaultDomainCount(2);
        }
        if (((AvailabilitySetInner)((Object)this.innerModel())).platformUpdateDomainCount() == null) {
            ((AvailabilitySetInner)((Object)this.innerModel())).withPlatformUpdateDomainCount(5);
        }
        return this.createNewProximityPlacementGroupAsync().flatMap(availabilitySet -> ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getAvailabilitySets().createOrUpdateAsync(this.resourceGroupName(), this.name(), (AvailabilitySetInner)((Object)((Object)this.innerModel()))).map(availabilitySetInner -> {
            self.setInner(availabilitySetInner);
            this.idOfVMsInSet = null;
            return self;
        }));
    }

    private Mono<AvailabilitySetImpl> createNewProximityPlacementGroupAsync() {
        if (this.isInCreateMode() && this.newProximityPlacementGroupName != null && !this.newProximityPlacementGroupName.isEmpty()) {
            ProximityPlacementGroupInner plgInner = new ProximityPlacementGroupInner();
            plgInner.withProximityPlacementGroupType(this.newProximityPlacementGroupType);
            plgInner.withLocation(((AvailabilitySetInner)((Object)this.innerModel())).location());
            return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getProximityPlacementGroups().createOrUpdateAsync(this.resourceGroupName(), this.newProximityPlacementGroupName, plgInner).map(createdPlgInner -> {
                ((AvailabilitySetInner)((Object)((Object)this.innerModel()))).withProximityPlacementGroup(new SubResource().withId(createdPlgInner.id()));
                return this;
            });
        }
        return Mono.just((Object)this);
    }
}

