/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.management.Region;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryImageVersionInner;
import com.azure.resourcemanager.compute.models.GalleryArtifactVersionSource;
import com.azure.resourcemanager.compute.models.GalleryImageVersion;
import com.azure.resourcemanager.compute.models.GalleryImageVersionPublishingProfile;
import com.azure.resourcemanager.compute.models.GalleryImageVersionStorageProfile;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.azure.resourcemanager.compute.models.TargetRegion;
import com.azure.resourcemanager.compute.models.VirtualMachineCustomImage;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

class GalleryImageVersionImpl
extends CreatableUpdatableImpl<GalleryImageVersion, GalleryImageVersionInner, GalleryImageVersionImpl>
implements GalleryImageVersion,
GalleryImageVersion.Definition,
GalleryImageVersion.Update {
    private final ComputeManager manager;
    private String resourceGroupName;
    private String galleryName;
    private String galleryImageName;
    private String galleryImageVersionName;

    GalleryImageVersionImpl(String name, ComputeManager manager) {
        super(name, (Object)new GalleryImageVersionInner());
        this.manager = manager;
        this.galleryImageVersionName = name;
    }

    GalleryImageVersionImpl(GalleryImageVersionInner inner, ComputeManager manager) {
        super(inner.name(), (Object)inner);
        this.manager = manager;
        this.galleryImageVersionName = inner.name();
        this.resourceGroupName = GalleryImageVersionImpl.getValueFromIdByName(inner.id(), "resourceGroups");
        this.galleryName = GalleryImageVersionImpl.getValueFromIdByName(inner.id(), "galleries");
        this.galleryImageName = GalleryImageVersionImpl.getValueFromIdByName(inner.id(), "images");
        this.galleryImageVersionName = GalleryImageVersionImpl.getValueFromIdByName(inner.id(), "versions");
    }

    public ComputeManager manager() {
        return this.manager;
    }

    public Mono<GalleryImageVersion> createResourceAsync() {
        return ((ComputeManagementClient)this.manager().serviceClient()).getGalleryImageVersions().createOrUpdateAsync(this.resourceGroupName, this.galleryName, this.galleryImageName, this.galleryImageVersionName, (GalleryImageVersionInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Mono<GalleryImageVersion> updateResourceAsync() {
        return ((ComputeManagementClient)this.manager().serviceClient()).getGalleryImageVersions().createOrUpdateAsync(this.resourceGroupName, this.galleryName, this.galleryImageName, this.galleryImageVersionName, (GalleryImageVersionInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<GalleryImageVersionInner> getInnerAsync() {
        return ((ComputeManagementClient)this.manager().serviceClient()).getGalleryImageVersions().getAsync(this.resourceGroupName, this.galleryName, this.galleryImageName, this.galleryImageVersionName);
    }

    public boolean isInCreateMode() {
        return ((GalleryImageVersionInner)((Object)this.innerModel())).id() == null;
    }

    @Override
    public String id() {
        return ((GalleryImageVersionInner)((Object)this.innerModel())).id();
    }

    @Override
    public String location() {
        return ((GalleryImageVersionInner)((Object)this.innerModel())).location();
    }

    @Override
    public String name() {
        return ((GalleryImageVersionInner)((Object)this.innerModel())).name();
    }

    @Override
    public String provisioningState() {
        return ((GalleryImageVersionInner)((Object)this.innerModel())).provisioningState().toString();
    }

    @Override
    public GalleryImageVersionPublishingProfile publishingProfile() {
        return ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile();
    }

    @Override
    public List<TargetRegion> availableRegions() {
        ArrayList<TargetRegion> regions = new ArrayList<TargetRegion>();
        if (((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile() != null && ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().targetRegions() != null) {
            for (TargetRegion targetRegion : ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().targetRegions()) {
                regions.add(new TargetRegion().withName(targetRegion.name()).withRegionalReplicaCount(targetRegion.regionalReplicaCount()));
            }
        }
        return Collections.unmodifiableList(regions);
    }

    @Override
    public OffsetDateTime endOfLifeDate() {
        if (((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile() != null) {
            return ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().endOfLifeDate();
        }
        return null;
    }

    @Override
    public Boolean isExcludedFromLatest() {
        if (((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile() != null) {
            return ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().excludeFromLatest();
        }
        return false;
    }

    @Override
    public ReplicationStatus replicationStatus() {
        return ((GalleryImageVersionInner)((Object)this.innerModel())).replicationStatus();
    }

    @Override
    public GalleryImageVersionStorageProfile storageProfile() {
        return ((GalleryImageVersionInner)((Object)this.innerModel())).storageProfile();
    }

    @Override
    public Map<String, String> tags() {
        return ((GalleryImageVersionInner)((Object)this.innerModel())).tags();
    }

    @Override
    public String type() {
        return ((GalleryImageVersionInner)((Object)this.innerModel())).type();
    }

    @Override
    public GalleryImageVersionImpl withExistingImage(String resourceGroupName, String galleryName, String galleryImageName) {
        this.resourceGroupName = resourceGroupName;
        this.galleryName = galleryName;
        this.galleryImageName = galleryImageName;
        return this;
    }

    @Override
    public GalleryImageVersionImpl withLocation(String location) {
        ((GalleryImageVersionInner)((Object)this.innerModel())).withLocation(location);
        return this;
    }

    @Override
    public GalleryImageVersion.DefinitionStages.WithSource withLocation(Region location) {
        ((GalleryImageVersionInner)((Object)this.innerModel())).withLocation(location.toString());
        return this;
    }

    @Override
    public GalleryImageVersionImpl withSourceCustomImage(String customImageId) {
        if (((GalleryImageVersionInner)((Object)this.innerModel())).storageProfile() == null) {
            ((GalleryImageVersionInner)((Object)this.innerModel())).withStorageProfile(new GalleryImageVersionStorageProfile());
        }
        if (((GalleryImageVersionInner)((Object)this.innerModel())).storageProfile().source() == null) {
            ((GalleryImageVersionInner)((Object)this.innerModel())).storageProfile().withSource(new GalleryArtifactVersionSource());
        }
        ((GalleryImageVersionInner)((Object)this.innerModel())).storageProfile().source().withId(customImageId);
        return this;
    }

    @Override
    public GalleryImageVersionImpl withSourceCustomImage(VirtualMachineCustomImage customImage) {
        return this.withSourceCustomImage(customImage.id());
    }

    @Override
    public GalleryImageVersionImpl withRegionAvailability(Region region, int replicaCount) {
        if (((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile() == null) {
            ((GalleryImageVersionInner)((Object)this.innerModel())).withPublishingProfile(new GalleryImageVersionPublishingProfile());
        }
        if (((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().targetRegions() == null) {
            ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().withTargetRegions(new ArrayList<TargetRegion>());
        }
        boolean found = false;
        String newRegionName = region.toString();
        String newRegionNameTrimmed = newRegionName.replaceAll("\\s", "");
        for (TargetRegion targetRegion : ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().targetRegions()) {
            String regionStr = targetRegion.name();
            String regionStrTrimmed = regionStr.replaceAll("\\s", "");
            if (!regionStrTrimmed.equalsIgnoreCase(newRegionNameTrimmed)) continue;
            targetRegion.withRegionalReplicaCount(replicaCount);
            found = true;
            break;
        }
        if (!found) {
            TargetRegion targetRegion = new TargetRegion().withName(newRegionName).withRegionalReplicaCount(replicaCount);
            ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().targetRegions().add(targetRegion);
        }
        found = false;
        String locationTrimmed = this.location().replaceAll("\\s", "");
        for (TargetRegion targetRegion : ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().targetRegions()) {
            String regionStr = targetRegion.name();
            String regionStrTrimmed = regionStr.replaceAll("\\s", "");
            if (!regionStrTrimmed.equalsIgnoreCase(locationTrimmed)) continue;
            found = true;
            break;
        }
        if (!found) {
            TargetRegion targetRegion = new TargetRegion().withName(this.location()).withRegionalReplicaCount(null);
            ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().targetRegions().add(targetRegion);
        }
        return this;
    }

    @Override
    public GalleryImageVersionImpl withRegionAvailability(List<TargetRegion> targetRegions) {
        if (((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile() == null) {
            ((GalleryImageVersionInner)((Object)this.innerModel())).withPublishingProfile(new GalleryImageVersionPublishingProfile());
        }
        ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().withTargetRegions(targetRegions);
        boolean found = false;
        String locationTrimmed = this.location().replaceAll("\\s", "");
        for (TargetRegion targetRegion : ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().targetRegions()) {
            String regionStr = targetRegion.name();
            String regionStrTrimmed = regionStr.replaceAll("\\s", "");
            if (!regionStrTrimmed.equalsIgnoreCase(locationTrimmed)) continue;
            found = true;
            break;
        }
        if (!found) {
            TargetRegion defaultTargetRegion = new TargetRegion().withName(this.location()).withRegionalReplicaCount(null);
            ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().targetRegions().add(defaultTargetRegion);
        }
        return this;
    }

    @Override
    public GalleryImageVersion.Update withoutRegionAvailability(Region region) {
        if (((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile() != null && ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().targetRegions() != null) {
            int foundIndex = -1;
            int i = 0;
            String regionNameToRemove = region.toString();
            String regionNameToRemoveTrimmed = regionNameToRemove.replaceAll("\\s", "");
            for (TargetRegion targetRegion : ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().targetRegions()) {
                String regionStr = targetRegion.name();
                String regionStrTrimmed = regionStr.replaceAll("\\s", "");
                if (regionStrTrimmed.equalsIgnoreCase(regionNameToRemoveTrimmed)) {
                    foundIndex = i;
                    break;
                }
                ++i;
            }
            if (foundIndex != -1) {
                ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().targetRegions().remove(foundIndex);
            }
        }
        return this;
    }

    @Override
    public GalleryImageVersionImpl withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        if (((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile() == null) {
            ((GalleryImageVersionInner)((Object)this.innerModel())).withPublishingProfile(new GalleryImageVersionPublishingProfile());
        }
        ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().withEndOfLifeDate(endOfLifeDate);
        return this;
    }

    @Override
    public GalleryImageVersionImpl withExcludedFromLatest() {
        if (((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile() == null) {
            ((GalleryImageVersionInner)((Object)this.innerModel())).withPublishingProfile(new GalleryImageVersionPublishingProfile());
        }
        ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().withExcludeFromLatest(true);
        return this;
    }

    @Override
    public GalleryImageVersionImpl withoutExcludedFromLatest() {
        if (((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile() == null) {
            ((GalleryImageVersionInner)((Object)this.innerModel())).withPublishingProfile(new GalleryImageVersionPublishingProfile());
        }
        ((GalleryImageVersionInner)((Object)this.innerModel())).publishingProfile().withExcludeFromLatest(false);
        return this;
    }

    @Override
    public GalleryImageVersionImpl withTags(Map<String, String> tags) {
        ((GalleryImageVersionInner)((Object)this.innerModel())).withTags(tags);
        return this;
    }

    private static String getValueFromIdByName(String id, String name) {
        if (id == null) {
            return null;
        }
        List<String> iterable = Arrays.asList(id.split("/"));
        Iterator itr = iterable.iterator();
        while (itr.hasNext()) {
            String part = (String)itr.next();
            if (part == null || part.trim().isEmpty() || !part.equalsIgnoreCase(name)) continue;
            if (itr.hasNext()) {
                return (String)itr.next();
            }
            return null;
        }
        return null;
    }
}

