/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.VirtualMachineScaleSetVMsClient;
import com.azure.resourcemanager.compute.fluent.models.RunCommandResultInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetVMInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetVMInstanceViewInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.InstanceViewTypes;
import com.azure.resourcemanager.compute.models.RunCommandInput;
import com.azure.resourcemanager.compute.models.VirtualMachineReimageParameters;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VirtualMachineScaleSetVMsClientImpl
implements VirtualMachineScaleSetVMsClient {
    private final ClientLogger logger = new ClientLogger(VirtualMachineScaleSetVMsClientImpl.class);
    private final VirtualMachineScaleSetVMsService service;
    private final ComputeManagementClientImpl client;

    VirtualMachineScaleSetVMsClientImpl(ComputeManagementClientImpl client) {
        this.service = (VirtualMachineScaleSetVMsService)RestProxy.create(VirtualMachineScaleSetVMsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean tempDisk) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineReimageParameters vmScaleSetVMReimageInputInternal = null;
        if (tempDisk != null) {
            vmScaleSetVMReimageInputInternal = new VirtualMachineReimageParameters();
            vmScaleSetVMReimageInputInternal.withTempDisk(tempDisk);
        }
        VirtualMachineReimageParameters vmScaleSetVMReimageInput = vmScaleSetVMReimageInputInternal;
        return FluxUtil.withContext(context -> this.service.reimage(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), vmScaleSetVMReimageInput, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean tempDisk, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        VirtualMachineReimageParameters vmScaleSetVMReimageInputInternal = null;
        if (tempDisk != null) {
            vmScaleSetVMReimageInputInternal = new VirtualMachineReimageParameters();
            vmScaleSetVMReimageInputInternal.withTempDisk(tempDisk);
        }
        VirtualMachineReimageParameters vmScaleSetVMReimageInput = vmScaleSetVMReimageInputInternal;
        context = this.client.mergeContext(context);
        return this.service.reimage(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), vmScaleSetVMReimageInput, context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginReimageAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean tempDisk) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, tempDisk);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginReimageAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean tempDisk, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, tempDisk, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginReimage(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean tempDisk) {
        return this.beginReimageAsync(resourceGroupName, vmScaleSetName, instanceId, tempDisk).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginReimage(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean tempDisk, Context context) {
        return this.beginReimageAsync(resourceGroupName, vmScaleSetName, instanceId, tempDisk, context).getSyncPoller();
    }

    @Override
    public Mono<Void> reimageAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean tempDisk) {
        return this.beginReimageAsync(resourceGroupName, vmScaleSetName, instanceId, tempDisk).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> reimageAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean tempDisk, Context context) {
        return this.beginReimageAsync(resourceGroupName, vmScaleSetName, instanceId, tempDisk, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<Void> reimageAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        Boolean tempDisk = null;
        return this.beginReimageAsync(resourceGroupName, vmScaleSetName, instanceId, tempDisk).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void reimage(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean tempDisk) {
        this.reimageAsync(resourceGroupName, vmScaleSetName, instanceId, tempDisk).block();
    }

    @Override
    public void reimage(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean tempDisk, Context context) {
        this.reimageAsync(resourceGroupName, vmScaleSetName, instanceId, tempDisk, context).block();
    }

    @Override
    public void reimage(String resourceGroupName, String vmScaleSetName, String instanceId) {
        Boolean tempDisk = null;
        this.reimageAsync(resourceGroupName, vmScaleSetName, instanceId, tempDisk).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> reimageAllWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.reimageAll(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> reimageAllWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.reimageAll(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginReimageAllAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageAllWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginReimageAllAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.reimageAllWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginReimageAll(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginReimageAllAsync(resourceGroupName, vmScaleSetName, instanceId).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginReimageAll(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginReimageAllAsync(resourceGroupName, vmScaleSetName, instanceId, context).getSyncPoller();
    }

    @Override
    public Mono<Void> reimageAllAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginReimageAllAsync(resourceGroupName, vmScaleSetName, instanceId).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> reimageAllAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginReimageAllAsync(resourceGroupName, vmScaleSetName, instanceId, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void reimageAll(String resourceGroupName, String vmScaleSetName, String instanceId) {
        this.reimageAllAsync(resourceGroupName, vmScaleSetName, instanceId).block();
    }

    @Override
    public void reimageAll(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        this.reimageAllAsync(resourceGroupName, vmScaleSetName, instanceId, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deallocateWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.deallocate(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deallocateWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.deallocate(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeallocateAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deallocateWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeallocateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deallocateWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeallocate(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginDeallocateAsync(resourceGroupName, vmScaleSetName, instanceId).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDeallocate(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginDeallocateAsync(resourceGroupName, vmScaleSetName, instanceId, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deallocateAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginDeallocateAsync(resourceGroupName, vmScaleSetName, instanceId).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deallocateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginDeallocateAsync(resourceGroupName, vmScaleSetName, instanceId, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void deallocate(String resourceGroupName, String vmScaleSetName, String instanceId) {
        this.deallocateAsync(resourceGroupName, vmScaleSetName, instanceId).block();
    }

    @Override
    public void deallocate(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        this.deallocateAsync(resourceGroupName, vmScaleSetName, instanceId, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, VirtualMachineScaleSetVMInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, VirtualMachineScaleSetVMInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public PollerFlux<PollResult<VirtualMachineScaleSetVMInner>, VirtualMachineScaleSetVMInner> beginUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, VirtualMachineScaleSetVMInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineScaleSetVMInner.class), (Type)((Object)VirtualMachineScaleSetVMInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<VirtualMachineScaleSetVMInner>, VirtualMachineScaleSetVMInner> beginUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, VirtualMachineScaleSetVMInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineScaleSetVMInner.class), (Type)((Object)VirtualMachineScaleSetVMInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<VirtualMachineScaleSetVMInner>, VirtualMachineScaleSetVMInner> beginUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, VirtualMachineScaleSetVMInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, parameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<VirtualMachineScaleSetVMInner>, VirtualMachineScaleSetVMInner> beginUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, VirtualMachineScaleSetVMInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, parameters, context).getSyncPoller();
    }

    @Override
    public Mono<VirtualMachineScaleSetVMInner> updateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, VirtualMachineScaleSetVMInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<VirtualMachineScaleSetVMInner> updateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, VirtualMachineScaleSetVMInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public VirtualMachineScaleSetVMInner update(String resourceGroupName, String vmScaleSetName, String instanceId, VirtualMachineScaleSetVMInner parameters) {
        return (VirtualMachineScaleSetVMInner)((Object)this.updateAsync(resourceGroupName, vmScaleSetName, instanceId, parameters).block());
    }

    @Override
    public VirtualMachineScaleSetVMInner update(String resourceGroupName, String vmScaleSetName, String instanceId, VirtualMachineScaleSetVMInner parameters, Context context) {
        return (VirtualMachineScaleSetVMInner)((Object)this.updateAsync(resourceGroupName, vmScaleSetName, instanceId, parameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName, instanceId).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName, instanceId, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName, instanceId).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName, instanceId, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String vmScaleSetName, String instanceId) {
        this.deleteAsync(resourceGroupName, vmScaleSetName, instanceId).block();
    }

    @Override
    public void delete(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        this.deleteAsync(resourceGroupName, vmScaleSetName, instanceId, context).block();
    }

    @Override
    public Mono<Response<VirtualMachineScaleSetVMInner>> getWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, InstanceViewTypes expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, expand, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<VirtualMachineScaleSetVMInner>> getWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, InstanceViewTypes expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, expand, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<VirtualMachineScaleSetVMInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, InstanceViewTypes expand) {
        return this.getWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((VirtualMachineScaleSetVMInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<VirtualMachineScaleSetVMInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        InstanceViewTypes expand = null;
        return this.getWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((VirtualMachineScaleSetVMInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public VirtualMachineScaleSetVMInner get(String resourceGroupName, String vmScaleSetName, String instanceId) {
        InstanceViewTypes expand = null;
        return (VirtualMachineScaleSetVMInner)((Object)this.getAsync(resourceGroupName, vmScaleSetName, instanceId, expand).block());
    }

    @Override
    public Response<VirtualMachineScaleSetVMInner> getWithResponse(String resourceGroupName, String vmScaleSetName, String instanceId, InstanceViewTypes expand, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, expand, context).block();
    }

    @Override
    public Mono<Response<VirtualMachineScaleSetVMInstanceViewInner>> getInstanceViewWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.getInstanceView(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<VirtualMachineScaleSetVMInstanceViewInner>> getInstanceViewWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.getInstanceView(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<VirtualMachineScaleSetVMInstanceViewInner> getInstanceViewAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.getInstanceViewWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((VirtualMachineScaleSetVMInstanceViewInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public VirtualMachineScaleSetVMInstanceViewInner getInstanceView(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return (VirtualMachineScaleSetVMInstanceViewInner)this.getInstanceViewAsync(resourceGroupName, vmScaleSetName, instanceId).block();
    }

    @Override
    public Response<VirtualMachineScaleSetVMInstanceViewInner> getInstanceViewWithResponse(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return (Response)this.getInstanceViewWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, context).block();
    }

    private Mono<PagedResponse<VirtualMachineScaleSetVMInner>> listSinglePageAsync(String resourceGroupName, String virtualMachineScaleSetName, String filter, String select, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualMachineScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, virtualMachineScaleSetName, filter, select, expand, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetVMListResult)res.getValue()).value(), ((VirtualMachineScaleSetVMListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<VirtualMachineScaleSetVMInner>> listSinglePageAsync(String resourceGroupName, String virtualMachineScaleSetName, String filter, String select, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualMachineScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualMachineScaleSetName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, virtualMachineScaleSetName, filter, select, expand, "2019-12-01", this.client.getSubscriptionId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetVMListResult)res.getValue()).value(), ((VirtualMachineScaleSetVMListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<VirtualMachineScaleSetVMInner> listAsync(String resourceGroupName, String virtualMachineScaleSetName, String filter, String select, String expand) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, virtualMachineScaleSetName, filter, select, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<VirtualMachineScaleSetVMInner> listAsync(String resourceGroupName, String virtualMachineScaleSetName) {
        String filter = null;
        String select = null;
        String expand = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, virtualMachineScaleSetName, filter, select, expand), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<VirtualMachineScaleSetVMInner> listAsync(String resourceGroupName, String virtualMachineScaleSetName, String filter, String select, String expand, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, virtualMachineScaleSetName, filter, select, expand, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<VirtualMachineScaleSetVMInner> list(String resourceGroupName, String virtualMachineScaleSetName, String filter, String select, String expand, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, virtualMachineScaleSetName, filter, select, expand, context));
    }

    @Override
    public PagedIterable<VirtualMachineScaleSetVMInner> list(String resourceGroupName, String virtualMachineScaleSetName) {
        String filter = null;
        String select = null;
        String expand = null;
        return new PagedIterable(this.listAsync(resourceGroupName, virtualMachineScaleSetName, filter, select, expand));
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> powerOffWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean skipShutdown) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.powerOff(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, skipShutdown, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> powerOffWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean skipShutdown, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.powerOff(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, skipShutdown, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginPowerOffAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean skipShutdown) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.powerOffWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, skipShutdown);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginPowerOffAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean skipShutdown, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.powerOffWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, skipShutdown, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginPowerOff(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean skipShutdown) {
        return this.beginPowerOffAsync(resourceGroupName, vmScaleSetName, instanceId, skipShutdown).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginPowerOff(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean skipShutdown, Context context) {
        return this.beginPowerOffAsync(resourceGroupName, vmScaleSetName, instanceId, skipShutdown, context).getSyncPoller();
    }

    @Override
    public Mono<Void> powerOffAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean skipShutdown) {
        return this.beginPowerOffAsync(resourceGroupName, vmScaleSetName, instanceId, skipShutdown).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> powerOffAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean skipShutdown, Context context) {
        return this.beginPowerOffAsync(resourceGroupName, vmScaleSetName, instanceId, skipShutdown, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<Void> powerOffAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        Boolean skipShutdown = null;
        return this.beginPowerOffAsync(resourceGroupName, vmScaleSetName, instanceId, skipShutdown).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void powerOff(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean skipShutdown) {
        this.powerOffAsync(resourceGroupName, vmScaleSetName, instanceId, skipShutdown).block();
    }

    @Override
    public void powerOff(String resourceGroupName, String vmScaleSetName, String instanceId, Boolean skipShutdown, Context context) {
        this.powerOffAsync(resourceGroupName, vmScaleSetName, instanceId, skipShutdown, context).block();
    }

    @Override
    public void powerOff(String resourceGroupName, String vmScaleSetName, String instanceId) {
        Boolean skipShutdown = null;
        this.powerOffAsync(resourceGroupName, vmScaleSetName, instanceId, skipShutdown).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.restart(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.restart(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restartWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginRestartAsync(resourceGroupName, vmScaleSetName, instanceId).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginRestartAsync(resourceGroupName, vmScaleSetName, instanceId, context).getSyncPoller();
    }

    @Override
    public Mono<Void> restartAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginRestartAsync(resourceGroupName, vmScaleSetName, instanceId).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> restartAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginRestartAsync(resourceGroupName, vmScaleSetName, instanceId, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void restart(String resourceGroupName, String vmScaleSetName, String instanceId) {
        this.restartAsync(resourceGroupName, vmScaleSetName, instanceId).block();
    }

    @Override
    public void restart(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        this.restartAsync(resourceGroupName, vmScaleSetName, instanceId, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.start(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginStartAsync(resourceGroupName, vmScaleSetName, instanceId).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginStartAsync(resourceGroupName, vmScaleSetName, instanceId, context).getSyncPoller();
    }

    @Override
    public Mono<Void> startAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginStartAsync(resourceGroupName, vmScaleSetName, instanceId).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> startAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginStartAsync(resourceGroupName, vmScaleSetName, instanceId, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void start(String resourceGroupName, String vmScaleSetName, String instanceId) {
        this.startAsync(resourceGroupName, vmScaleSetName, instanceId).block();
    }

    @Override
    public void start(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        this.startAsync(resourceGroupName, vmScaleSetName, instanceId, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> redeployWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.redeploy(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> redeployWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.redeploy(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginRedeployAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.redeployWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginRedeployAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.redeployWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRedeploy(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginRedeployAsync(resourceGroupName, vmScaleSetName, instanceId).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginRedeploy(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginRedeployAsync(resourceGroupName, vmScaleSetName, instanceId, context).getSyncPoller();
    }

    @Override
    public Mono<Void> redeployAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginRedeployAsync(resourceGroupName, vmScaleSetName, instanceId).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> redeployAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginRedeployAsync(resourceGroupName, vmScaleSetName, instanceId, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void redeploy(String resourceGroupName, String vmScaleSetName, String instanceId) {
        this.redeployAsync(resourceGroupName, vmScaleSetName, instanceId).block();
    }

    @Override
    public void redeploy(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        this.redeployAsync(resourceGroupName, vmScaleSetName, instanceId, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> performMaintenanceWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.performMaintenance(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> performMaintenanceWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.performMaintenance(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginPerformMaintenanceAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.performMaintenanceWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginPerformMaintenanceAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.performMaintenanceWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginPerformMaintenance(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginPerformMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceId).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginPerformMaintenance(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginPerformMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceId, context).getSyncPoller();
    }

    @Override
    public Mono<Void> performMaintenanceAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.beginPerformMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceId).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> performMaintenanceAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return this.beginPerformMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceId, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void performMaintenance(String resourceGroupName, String vmScaleSetName, String instanceId) {
        this.performMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceId).block();
    }

    @Override
    public void performMaintenance(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        this.performMaintenanceAsync(resourceGroupName, vmScaleSetName, instanceId, context).block();
    }

    @Override
    public Mono<Response<Void>> simulateEvictionWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.simulateEviction(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> simulateEvictionWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.simulateEviction(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), context);
    }

    @Override
    public Mono<Void> simulateEvictionAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        return this.simulateEvictionWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId).flatMap(res -> Mono.empty());
    }

    @Override
    public void simulateEviction(String resourceGroupName, String vmScaleSetName, String instanceId) {
        this.simulateEvictionAsync(resourceGroupName, vmScaleSetName, instanceId).block();
    }

    @Override
    public Response<Void> simulateEvictionWithResponse(String resourceGroupName, String vmScaleSetName, String instanceId, Context context) {
        return (Response)this.simulateEvictionWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> runCommandWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, RunCommandInput parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-12-01";
        return FluxUtil.withContext(context -> this.service.runCommand(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> runCommandWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, RunCommandInput parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2019-12-01";
        context = this.client.mergeContext(context);
        return this.service.runCommand(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, "2019-12-01", this.client.getSubscriptionId(), parameters, context);
    }

    @Override
    public PollerFlux<PollResult<RunCommandResultInner>, RunCommandResultInner> beginRunCommandAsync(String resourceGroupName, String vmScaleSetName, String instanceId, RunCommandInput parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.runCommandWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RunCommandResultInner.class), (Type)((Object)RunCommandResultInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<RunCommandResultInner>, RunCommandResultInner> beginRunCommandAsync(String resourceGroupName, String vmScaleSetName, String instanceId, RunCommandInput parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.runCommandWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RunCommandResultInner.class), (Type)((Object)RunCommandResultInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<RunCommandResultInner>, RunCommandResultInner> beginRunCommand(String resourceGroupName, String vmScaleSetName, String instanceId, RunCommandInput parameters) {
        return this.beginRunCommandAsync(resourceGroupName, vmScaleSetName, instanceId, parameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<RunCommandResultInner>, RunCommandResultInner> beginRunCommand(String resourceGroupName, String vmScaleSetName, String instanceId, RunCommandInput parameters, Context context) {
        return this.beginRunCommandAsync(resourceGroupName, vmScaleSetName, instanceId, parameters, context).getSyncPoller();
    }

    @Override
    public Mono<RunCommandResultInner> runCommandAsync(String resourceGroupName, String vmScaleSetName, String instanceId, RunCommandInput parameters) {
        return this.beginRunCommandAsync(resourceGroupName, vmScaleSetName, instanceId, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<RunCommandResultInner> runCommandAsync(String resourceGroupName, String vmScaleSetName, String instanceId, RunCommandInput parameters, Context context) {
        return this.beginRunCommandAsync(resourceGroupName, vmScaleSetName, instanceId, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public RunCommandResultInner runCommand(String resourceGroupName, String vmScaleSetName, String instanceId, RunCommandInput parameters) {
        return (RunCommandResultInner)this.runCommandAsync(resourceGroupName, vmScaleSetName, instanceId, parameters).block();
    }

    @Override
    public RunCommandResultInner runCommand(String resourceGroupName, String vmScaleSetName, String instanceId, RunCommandInput parameters, Context context) {
        return (RunCommandResultInner)this.runCommandAsync(resourceGroupName, vmScaleSetName, instanceId, parameters, context).block();
    }

    private Mono<PagedResponse<VirtualMachineScaleSetVMInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetVMListResult)res.getValue()).value(), ((VirtualMachineScaleSetVMListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<VirtualMachineScaleSetVMInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineScaleSetVMListResult)res.getValue()).value(), ((VirtualMachineScaleSetVMListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    private static interface VirtualMachineScaleSetVMsService {
        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/reimage")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> reimage(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") VirtualMachineReimageParameters var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/reimageall")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> reimageAll(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/deallocate")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> deallocate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") VirtualMachineScaleSetVMInner var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetVMInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="$expand") InstanceViewTypes var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/instanceView")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetVMInstanceViewInner>> getInstanceView(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{virtualMachineScaleSetName}/virtualMachines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetVMListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="virtualMachineScaleSetName") String var3, @QueryParam(value="$filter") String var4, @QueryParam(value="$select") String var5, @QueryParam(value="$expand") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/poweroff")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> powerOff(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="skipShutdown") Boolean var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/restart")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> restart(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> start(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/redeploy")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> redeploy(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/performMaintenance")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> performMaintenance(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/simulateEviction")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> simulateEviction(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, Context var7);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualmachines/{instanceId}/runCommand")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> runCommand(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") RunCommandInput var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualMachineScaleSetVMListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

