/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.GalleryArtifactVersionSource;
import com.azure.resourcemanager.compute.models.GalleryDataDiskImage;
import com.azure.resourcemanager.compute.models.GalleryDiskImage;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class GalleryImageVersionStorageProfile {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(GalleryImageVersionStorageProfile.class);
    @JsonProperty(value="source")
    private GalleryArtifactVersionSource source;
    @JsonProperty(value="osDiskImage")
    private GalleryDiskImage osDiskImage;
    @JsonProperty(value="dataDiskImages")
    private List<GalleryDataDiskImage> dataDiskImages;

    public GalleryArtifactVersionSource source() {
        return this.source;
    }

    public GalleryImageVersionStorageProfile withSource(GalleryArtifactVersionSource source) {
        this.source = source;
        return this;
    }

    public GalleryDiskImage osDiskImage() {
        return this.osDiskImage;
    }

    public GalleryImageVersionStorageProfile withOsDiskImage(GalleryDiskImage osDiskImage) {
        this.osDiskImage = osDiskImage;
        return this;
    }

    public List<GalleryDataDiskImage> dataDiskImages() {
        return this.dataDiskImages;
    }

    public GalleryImageVersionStorageProfile withDataDiskImages(List<GalleryDataDiskImage> dataDiskImages) {
        this.dataDiskImages = dataDiskImages;
        return this;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.osDiskImage() != null) {
            this.osDiskImage().validate();
        }
        if (this.dataDiskImages() != null) {
            this.dataDiskImages().forEach(e -> e.validate());
        }
    }
}

