// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.containerservice.fluent.models.CredentialResultsInner;
import com.azure.resourcemanager.containerservice.fluent.models.ManagedClusterAccessProfileInner;
import com.azure.resourcemanager.containerservice.fluent.models.ManagedClusterInner;
import com.azure.resourcemanager.containerservice.fluent.models.ManagedClusterUpgradeProfileInner;
import com.azure.resourcemanager.containerservice.models.ManagedClusterAadProfile;
import com.azure.resourcemanager.containerservice.models.ManagedClusterServicePrincipalProfile;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ManagedClustersClient. */
public interface ManagedClustersClient
    extends InnerSupportsGet<ManagedClusterInner>,
        InnerSupportsListing<ManagedClusterInner>,
        InnerSupportsDelete<Void> {
    /**
     * Gets a list of managed clusters in the specified subscription. The operation returns properties of each managed
     * cluster.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed clusters in the specified subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagedClusterInner> listAsync();

    /**
     * Gets a list of managed clusters in the specified subscription. The operation returns properties of each managed
     * cluster.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed clusters in the specified subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedClusterInner> list();

    /**
     * Gets a list of managed clusters in the specified subscription. The operation returns properties of each managed
     * cluster.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of managed clusters in the specified subscription.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedClusterInner> list(Context context);

    /**
     * Lists managed clusters in the specified subscription and resource group. The operation returns properties of each
     * managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Managed Clusters operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ManagedClusterInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Lists managed clusters in the specified subscription and resource group. The operation returns properties of each
     * managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Managed Clusters operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedClusterInner> listByResourceGroup(String resourceGroupName);

    /**
     * Lists managed clusters in the specified subscription and resource group. The operation returns properties of each
     * managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response from the List Managed Clusters operation.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ManagedClusterInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Gets the details of the upgrade profile for a managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the upgrade profile for a managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagedClusterUpgradeProfileInner>> getUpgradeProfileWithResponseAsync(
        String resourceGroupName, String resourceName);

    /**
     * Gets the details of the upgrade profile for a managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the upgrade profile for a managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedClusterUpgradeProfileInner> getUpgradeProfileAsync(String resourceGroupName, String resourceName);

    /**
     * Gets the details of the upgrade profile for a managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the upgrade profile for a managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedClusterUpgradeProfileInner getUpgradeProfile(String resourceGroupName, String resourceName);

    /**
     * Gets the details of the upgrade profile for a managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the upgrade profile for a managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagedClusterUpgradeProfileInner> getUpgradeProfileWithResponse(
        String resourceGroupName, String resourceName, Context context);

    /**
     * Gets the accessProfile for the specified role name of the managed cluster with a specified resource group and
     * name. **WARNING**: This API will be deprecated. Instead use
     * [ListClusterUserCredentials](https://docs.microsoft.com/en-us/rest/api/aks/managedclusters/listclusterusercredentials)
     * or
     * [ListClusterAdminCredentials](https://docs.microsoft.com/en-us/rest/api/aks/managedclusters/listclusteradmincredentials)
     * .
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param roleName The name of the role for managed cluster accessProfile resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the accessProfile for the specified role name of the managed cluster with a specified resource group and
     *     name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagedClusterAccessProfileInner>> getAccessProfileWithResponseAsync(
        String resourceGroupName, String resourceName, String roleName);

    /**
     * Gets the accessProfile for the specified role name of the managed cluster with a specified resource group and
     * name. **WARNING**: This API will be deprecated. Instead use
     * [ListClusterUserCredentials](https://docs.microsoft.com/en-us/rest/api/aks/managedclusters/listclusterusercredentials)
     * or
     * [ListClusterAdminCredentials](https://docs.microsoft.com/en-us/rest/api/aks/managedclusters/listclusteradmincredentials)
     * .
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param roleName The name of the role for managed cluster accessProfile resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the accessProfile for the specified role name of the managed cluster with a specified resource group and
     *     name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedClusterAccessProfileInner> getAccessProfileAsync(
        String resourceGroupName, String resourceName, String roleName);

    /**
     * Gets the accessProfile for the specified role name of the managed cluster with a specified resource group and
     * name. **WARNING**: This API will be deprecated. Instead use
     * [ListClusterUserCredentials](https://docs.microsoft.com/en-us/rest/api/aks/managedclusters/listclusterusercredentials)
     * or
     * [ListClusterAdminCredentials](https://docs.microsoft.com/en-us/rest/api/aks/managedclusters/listclusteradmincredentials)
     * .
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param roleName The name of the role for managed cluster accessProfile resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the accessProfile for the specified role name of the managed cluster with a specified resource group and
     *     name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedClusterAccessProfileInner getAccessProfile(String resourceGroupName, String resourceName, String roleName);

    /**
     * Gets the accessProfile for the specified role name of the managed cluster with a specified resource group and
     * name. **WARNING**: This API will be deprecated. Instead use
     * [ListClusterUserCredentials](https://docs.microsoft.com/en-us/rest/api/aks/managedclusters/listclusterusercredentials)
     * or
     * [ListClusterAdminCredentials](https://docs.microsoft.com/en-us/rest/api/aks/managedclusters/listclusteradmincredentials)
     * .
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param roleName The name of the role for managed cluster accessProfile resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the accessProfile for the specified role name of the managed cluster with a specified resource group and
     *     name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagedClusterAccessProfileInner> getAccessProfileWithResponse(
        String resourceGroupName, String resourceName, String roleName, Context context);

    /**
     * Gets cluster admin credential of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cluster admin credential of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CredentialResultsInner>> listClusterAdminCredentialsWithResponseAsync(
        String resourceGroupName, String resourceName);

    /**
     * Gets cluster admin credential of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cluster admin credential of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CredentialResultsInner> listClusterAdminCredentialsAsync(String resourceGroupName, String resourceName);

    /**
     * Gets cluster admin credential of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cluster admin credential of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CredentialResultsInner listClusterAdminCredentials(String resourceGroupName, String resourceName);

    /**
     * Gets cluster admin credential of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cluster admin credential of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CredentialResultsInner> listClusterAdminCredentialsWithResponse(
        String resourceGroupName, String resourceName, Context context);

    /**
     * Gets cluster user credential of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cluster user credential of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CredentialResultsInner>> listClusterUserCredentialsWithResponseAsync(
        String resourceGroupName, String resourceName);

    /**
     * Gets cluster user credential of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cluster user credential of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CredentialResultsInner> listClusterUserCredentialsAsync(String resourceGroupName, String resourceName);

    /**
     * Gets cluster user credential of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cluster user credential of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CredentialResultsInner listClusterUserCredentials(String resourceGroupName, String resourceName);

    /**
     * Gets cluster user credential of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cluster user credential of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CredentialResultsInner> listClusterUserCredentialsWithResponse(
        String resourceGroupName, String resourceName, Context context);

    /**
     * Gets cluster monitoring user credential of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cluster monitoring user credential of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CredentialResultsInner>> listClusterMonitoringUserCredentialsWithResponseAsync(
        String resourceGroupName, String resourceName);

    /**
     * Gets cluster monitoring user credential of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cluster monitoring user credential of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CredentialResultsInner> listClusterMonitoringUserCredentialsAsync(
        String resourceGroupName, String resourceName);

    /**
     * Gets cluster monitoring user credential of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cluster monitoring user credential of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CredentialResultsInner listClusterMonitoringUserCredentials(String resourceGroupName, String resourceName);

    /**
     * Gets cluster monitoring user credential of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cluster monitoring user credential of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CredentialResultsInner> listClusterMonitoringUserCredentialsWithResponse(
        String resourceGroupName, String resourceName, Context context);

    /**
     * Gets the details of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ManagedClusterInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String resourceName);

    /**
     * Gets the details of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedClusterInner> getByResourceGroupAsync(String resourceGroupName, String resourceName);

    /**
     * Gets the details of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedClusterInner getByResourceGroup(String resourceGroupName, String resourceName);

    /**
     * Gets the details of the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the managed cluster with a specified resource group and name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ManagedClusterInner> getByResourceGroupWithResponse(
        String resourceGroupName, String resourceName, Context context);

    /**
     * Creates or updates a managed cluster with the specified configuration for agents and Kubernetes version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Managed cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String resourceName, ManagedClusterInner parameters);

    /**
     * Creates or updates a managed cluster with the specified configuration for agents and Kubernetes version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Managed cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ManagedClusterInner>, ManagedClusterInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String resourceName, ManagedClusterInner parameters);

    /**
     * Creates or updates a managed cluster with the specified configuration for agents and Kubernetes version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Managed cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ManagedClusterInner>, ManagedClusterInner> beginCreateOrUpdate(
        String resourceGroupName, String resourceName, ManagedClusterInner parameters);

    /**
     * Creates or updates a managed cluster with the specified configuration for agents and Kubernetes version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Managed cluster.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ManagedClusterInner>, ManagedClusterInner> beginCreateOrUpdate(
        String resourceGroupName, String resourceName, ManagedClusterInner parameters, Context context);

    /**
     * Creates or updates a managed cluster with the specified configuration for agents and Kubernetes version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Managed cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedClusterInner> createOrUpdateAsync(
        String resourceGroupName, String resourceName, ManagedClusterInner parameters);

    /**
     * Creates or updates a managed cluster with the specified configuration for agents and Kubernetes version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Managed cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedClusterInner createOrUpdate(String resourceGroupName, String resourceName, ManagedClusterInner parameters);

    /**
     * Creates or updates a managed cluster with the specified configuration for agents and Kubernetes version.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Managed cluster.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedClusterInner createOrUpdate(
        String resourceGroupName, String resourceName, ManagedClusterInner parameters, Context context);

    /**
     * Updates a managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateTagsWithResponseAsync(
        String resourceGroupName, String resourceName, Map<String, String> tags);

    /**
     * Updates a managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<ManagedClusterInner>, ManagedClusterInner> beginUpdateTagsAsync(
        String resourceGroupName, String resourceName, Map<String, String> tags);

    /**
     * Updates a managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ManagedClusterInner>, ManagedClusterInner> beginUpdateTags(
        String resourceGroupName, String resourceName, Map<String, String> tags);

    /**
     * Updates a managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param tags Resource tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<ManagedClusterInner>, ManagedClusterInner> beginUpdateTags(
        String resourceGroupName, String resourceName, Map<String, String> tags, Context context);

    /**
     * Updates a managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags);

    /**
     * Updates a managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ManagedClusterInner> updateTagsAsync(String resourceGroupName, String resourceName);

    /**
     * Updates a managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param tags Resource tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedClusterInner updateTags(String resourceGroupName, String resourceName, Map<String, String> tags);

    /**
     * Updates a managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param tags Resource tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedClusterInner updateTags(
        String resourceGroupName, String resourceName, Map<String, String> tags, Context context);

    /**
     * Updates a managed cluster with the specified tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return managed cluster.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ManagedClusterInner updateTags(String resourceGroupName, String resourceName);

    /**
     * Deletes the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceName);

    /**
     * Deletes the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String resourceName);

    /**
     * Deletes the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceName);

    /**
     * Deletes the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String resourceName, Context context);

    /**
     * Deletes the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String resourceName);

    /**
     * Deletes the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String resourceName);

    /**
     * Deletes the managed cluster with a specified resource group and name.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String resourceName, Context context);

    /**
     * Update the service principal Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Information about a service principal identity for the cluster to use for manipulating Azure
     *     APIs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> resetServicePrincipalProfileWithResponseAsync(
        String resourceGroupName, String resourceName, ManagedClusterServicePrincipalProfile parameters);

    /**
     * Update the service principal Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Information about a service principal identity for the cluster to use for manipulating Azure
     *     APIs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginResetServicePrincipalProfileAsync(
        String resourceGroupName, String resourceName, ManagedClusterServicePrincipalProfile parameters);

    /**
     * Update the service principal Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Information about a service principal identity for the cluster to use for manipulating Azure
     *     APIs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginResetServicePrincipalProfile(
        String resourceGroupName, String resourceName, ManagedClusterServicePrincipalProfile parameters);

    /**
     * Update the service principal Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Information about a service principal identity for the cluster to use for manipulating Azure
     *     APIs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginResetServicePrincipalProfile(
        String resourceGroupName,
        String resourceName,
        ManagedClusterServicePrincipalProfile parameters,
        Context context);

    /**
     * Update the service principal Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Information about a service principal identity for the cluster to use for manipulating Azure
     *     APIs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> resetServicePrincipalProfileAsync(
        String resourceGroupName, String resourceName, ManagedClusterServicePrincipalProfile parameters);

    /**
     * Update the service principal Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Information about a service principal identity for the cluster to use for manipulating Azure
     *     APIs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void resetServicePrincipalProfile(
        String resourceGroupName, String resourceName, ManagedClusterServicePrincipalProfile parameters);

    /**
     * Update the service principal Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters Information about a service principal identity for the cluster to use for manipulating Azure
     *     APIs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void resetServicePrincipalProfile(
        String resourceGroupName,
        String resourceName,
        ManagedClusterServicePrincipalProfile parameters,
        Context context);

    /**
     * Update the AAD Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters AADProfile specifies attributes for Azure Active Directory integration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> resetAadProfileWithResponseAsync(
        String resourceGroupName, String resourceName, ManagedClusterAadProfile parameters);

    /**
     * Update the AAD Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters AADProfile specifies attributes for Azure Active Directory integration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginResetAadProfileAsync(
        String resourceGroupName, String resourceName, ManagedClusterAadProfile parameters);

    /**
     * Update the AAD Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters AADProfile specifies attributes for Azure Active Directory integration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginResetAadProfile(
        String resourceGroupName, String resourceName, ManagedClusterAadProfile parameters);

    /**
     * Update the AAD Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters AADProfile specifies attributes for Azure Active Directory integration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginResetAadProfile(
        String resourceGroupName, String resourceName, ManagedClusterAadProfile parameters, Context context);

    /**
     * Update the AAD Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters AADProfile specifies attributes for Azure Active Directory integration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> resetAadProfileAsync(String resourceGroupName, String resourceName, ManagedClusterAadProfile parameters);

    /**
     * Update the AAD Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters AADProfile specifies attributes for Azure Active Directory integration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void resetAadProfile(String resourceGroupName, String resourceName, ManagedClusterAadProfile parameters);

    /**
     * Update the AAD Profile for a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param parameters AADProfile specifies attributes for Azure Active Directory integration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void resetAadProfile(
        String resourceGroupName, String resourceName, ManagedClusterAadProfile parameters, Context context);

    /**
     * Rotate certificates of a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> rotateClusterCertificatesWithResponseAsync(
        String resourceGroupName, String resourceName);

    /**
     * Rotate certificates of a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PollerFlux<PollResult<Void>, Void> beginRotateClusterCertificatesAsync(
        String resourceGroupName, String resourceName);

    /**
     * Rotate certificates of a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginRotateClusterCertificates(String resourceGroupName, String resourceName);

    /**
     * Rotate certificates of a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SyncPoller<PollResult<Void>, Void> beginRotateClusterCertificates(
        String resourceGroupName, String resourceName, Context context);

    /**
     * Rotate certificates of a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> rotateClusterCertificatesAsync(String resourceGroupName, String resourceName);

    /**
     * Rotate certificates of a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void rotateClusterCertificates(String resourceGroupName, String resourceName);

    /**
     * Rotate certificates of a managed cluster.
     *
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the managed cluster resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void rotateClusterCertificates(String resourceGroupName, String resourceName, Context context);
}
