// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPoolUpgradeProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The list of available upgrades for compute pools. */
@JsonFlatten
@Fluent
public class ManagedClusterUpgradeProfileInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ManagedClusterUpgradeProfileInner.class);

    /*
     * Id of upgrade profile.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * Name of upgrade profile.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * Type of upgrade profile.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * The list of available upgrade versions for the control plane.
     */
    @JsonProperty(value = "properties.controlPlaneProfile", required = true)
    private ManagedClusterPoolUpgradeProfile controlPlaneProfile;

    /*
     * The list of available upgrade versions for agent pools.
     */
    @JsonProperty(value = "properties.agentPoolProfiles", required = true)
    private List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles;

    /**
     * Get the id property: Id of upgrade profile.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: Name of upgrade profile.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Type of upgrade profile.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the controlPlaneProfile property: The list of available upgrade versions for the control plane.
     *
     * @return the controlPlaneProfile value.
     */
    public ManagedClusterPoolUpgradeProfile controlPlaneProfile() {
        return this.controlPlaneProfile;
    }

    /**
     * Set the controlPlaneProfile property: The list of available upgrade versions for the control plane.
     *
     * @param controlPlaneProfile the controlPlaneProfile value to set.
     * @return the ManagedClusterUpgradeProfileInner object itself.
     */
    public ManagedClusterUpgradeProfileInner withControlPlaneProfile(
        ManagedClusterPoolUpgradeProfile controlPlaneProfile) {
        this.controlPlaneProfile = controlPlaneProfile;
        return this;
    }

    /**
     * Get the agentPoolProfiles property: The list of available upgrade versions for agent pools.
     *
     * @return the agentPoolProfiles value.
     */
    public List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    /**
     * Set the agentPoolProfiles property: The list of available upgrade versions for agent pools.
     *
     * @param agentPoolProfiles the agentPoolProfiles value to set.
     * @return the ManagedClusterUpgradeProfileInner object itself.
     */
    public ManagedClusterUpgradeProfileInner withAgentPoolProfiles(
        List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (controlPlaneProfile() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property controlPlaneProfile in model ManagedClusterUpgradeProfileInner"));
        } else {
            controlPlaneProfile().validate();
        }
        if (agentPoolProfiles() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property agentPoolProfiles in model ManagedClusterUpgradeProfileInner"));
        } else {
            agentPoolProfiles().forEach(e -> e.validate());
        }
    }
}
