// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/** The Components1Q1Og48SchemasManagedclusterAllof1 model. */
@JsonFlatten
@Fluent
public class Components1Q1Og48SchemasManagedclusterAllof1 {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Components1Q1Og48SchemasManagedclusterAllof1.class);

    /*
     * The identity of the managed cluster, if configured.
     */
    @JsonProperty(value = "identity")
    private ManagedClusterIdentity identity;

    /*
     * The current deployment or provisioning state, which only appears in the
     * response.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;

    /*
     * The max number of agent pools for the managed cluster.
     */
    @JsonProperty(value = "properties.maxAgentPools", access = JsonProperty.Access.WRITE_ONLY)
    private Integer maxAgentPools;

    /*
     * Version of Kubernetes specified when creating the managed cluster.
     */
    @JsonProperty(value = "properties.kubernetesVersion")
    private String kubernetesVersion;

    /*
     * DNS prefix specified when creating the managed cluster.
     */
    @JsonProperty(value = "properties.dnsPrefix")
    private String dnsPrefix;

    /*
     * FQDN for the master pool.
     */
    @JsonProperty(value = "properties.fqdn", access = JsonProperty.Access.WRITE_ONLY)
    private String fqdn;

    /*
     * FQDN of private cluster.
     */
    @JsonProperty(value = "properties.privateFQDN", access = JsonProperty.Access.WRITE_ONLY)
    private String privateFqdn;

    /*
     * Properties of the agent pool.
     */
    @JsonProperty(value = "properties.agentPoolProfiles")
    private List<ManagedClusterAgentPoolProfile> agentPoolProfiles;

    /*
     * Profile for Linux VMs in the container service cluster.
     */
    @JsonProperty(value = "properties.linuxProfile")
    private ContainerServiceLinuxProfile linuxProfile;

    /*
     * Profile for Windows VMs in the container service cluster.
     */
    @JsonProperty(value = "properties.windowsProfile")
    private ManagedClusterWindowsProfile windowsProfile;

    /*
     * Information about a service principal identity for the cluster to use
     * for manipulating Azure APIs.
     */
    @JsonProperty(value = "properties.servicePrincipalProfile")
    private ManagedClusterServicePrincipalProfile servicePrincipalProfile;

    /*
     * Profile of managed cluster add-on.
     */
    @JsonProperty(value = "properties.addonProfiles")
    private Map<String, ManagedClusterAddonProfile> addonProfiles;

    /*
     * Name of the resource group containing agent pool nodes.
     */
    @JsonProperty(value = "properties.nodeResourceGroup")
    private String nodeResourceGroup;

    /*
     * Whether to enable Kubernetes Role-Based Access Control.
     */
    @JsonProperty(value = "properties.enableRBAC")
    private Boolean enableRbac;

    /*
     * (DEPRECATING) Whether to enable Kubernetes pod security policy
     * (preview). This feature is set for removal on October 15th, 2020. Learn
     * more at aka.ms/aks/azpodpolicy.
     */
    @JsonProperty(value = "properties.enablePodSecurityPolicy")
    private Boolean enablePodSecurityPolicy;

    /*
     * Profile of network configuration.
     */
    @JsonProperty(value = "properties.networkProfile")
    private ContainerServiceNetworkProfile networkProfile;

    /*
     * Profile of Azure Active Directory configuration.
     */
    @JsonProperty(value = "properties.aadProfile")
    private ManagedClusterAadProfile aadProfile;

    /*
     * Parameters to be applied to the cluster-autoscaler when enabled
     */
    @JsonProperty(value = "properties.autoScalerProfile")
    private ManagedClusterPropertiesAutoScalerProfile autoScalerProfile;

    /*
     * Access profile for managed cluster API server.
     */
    @JsonProperty(value = "properties.apiServerAccessProfile")
    private ManagedClusterApiServerAccessProfile apiServerAccessProfile;

    /*
     * ResourceId of the disk encryption set to use for enabling encryption at
     * rest.
     */
    @JsonProperty(value = "properties.diskEncryptionSetID")
    private String diskEncryptionSetId;

    /*
     * Identities associated with the cluster.
     */
    @JsonProperty(value = "properties.identityProfile")
    private Map<String, UserAssignedIdentity> identityProfile;

    /**
     * Get the identity property: The identity of the managed cluster, if configured.
     *
     * @return the identity value.
     */
    public ManagedClusterIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The identity of the managed cluster, if configured.
     *
     * @param identity the identity value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withIdentity(ManagedClusterIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the provisioningState property: The current deployment or provisioning state, which only appears in the
     * response.
     *
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the maxAgentPools property: The max number of agent pools for the managed cluster.
     *
     * @return the maxAgentPools value.
     */
    public Integer maxAgentPools() {
        return this.maxAgentPools;
    }

    /**
     * Get the kubernetesVersion property: Version of Kubernetes specified when creating the managed cluster.
     *
     * @return the kubernetesVersion value.
     */
    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    /**
     * Set the kubernetesVersion property: Version of Kubernetes specified when creating the managed cluster.
     *
     * @param kubernetesVersion the kubernetesVersion value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
        return this;
    }

    /**
     * Get the dnsPrefix property: DNS prefix specified when creating the managed cluster.
     *
     * @return the dnsPrefix value.
     */
    public String dnsPrefix() {
        return this.dnsPrefix;
    }

    /**
     * Set the dnsPrefix property: DNS prefix specified when creating the managed cluster.
     *
     * @param dnsPrefix the dnsPrefix value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withDnsPrefix(String dnsPrefix) {
        this.dnsPrefix = dnsPrefix;
        return this;
    }

    /**
     * Get the fqdn property: FQDN for the master pool.
     *
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Get the privateFqdn property: FQDN of private cluster.
     *
     * @return the privateFqdn value.
     */
    public String privateFqdn() {
        return this.privateFqdn;
    }

    /**
     * Get the agentPoolProfiles property: Properties of the agent pool.
     *
     * @return the agentPoolProfiles value.
     */
    public List<ManagedClusterAgentPoolProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    /**
     * Set the agentPoolProfiles property: Properties of the agent pool.
     *
     * @param agentPoolProfiles the agentPoolProfiles value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withAgentPoolProfiles(
        List<ManagedClusterAgentPoolProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    /**
     * Get the linuxProfile property: Profile for Linux VMs in the container service cluster.
     *
     * @return the linuxProfile value.
     */
    public ContainerServiceLinuxProfile linuxProfile() {
        return this.linuxProfile;
    }

    /**
     * Set the linuxProfile property: Profile for Linux VMs in the container service cluster.
     *
     * @param linuxProfile the linuxProfile value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withLinuxProfile(ContainerServiceLinuxProfile linuxProfile) {
        this.linuxProfile = linuxProfile;
        return this;
    }

    /**
     * Get the windowsProfile property: Profile for Windows VMs in the container service cluster.
     *
     * @return the windowsProfile value.
     */
    public ManagedClusterWindowsProfile windowsProfile() {
        return this.windowsProfile;
    }

    /**
     * Set the windowsProfile property: Profile for Windows VMs in the container service cluster.
     *
     * @param windowsProfile the windowsProfile value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withWindowsProfile(
        ManagedClusterWindowsProfile windowsProfile) {
        this.windowsProfile = windowsProfile;
        return this;
    }

    /**
     * Get the servicePrincipalProfile property: Information about a service principal identity for the cluster to use
     * for manipulating Azure APIs.
     *
     * @return the servicePrincipalProfile value.
     */
    public ManagedClusterServicePrincipalProfile servicePrincipalProfile() {
        return this.servicePrincipalProfile;
    }

    /**
     * Set the servicePrincipalProfile property: Information about a service principal identity for the cluster to use
     * for manipulating Azure APIs.
     *
     * @param servicePrincipalProfile the servicePrincipalProfile value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withServicePrincipalProfile(
        ManagedClusterServicePrincipalProfile servicePrincipalProfile) {
        this.servicePrincipalProfile = servicePrincipalProfile;
        return this;
    }

    /**
     * Get the addonProfiles property: Profile of managed cluster add-on.
     *
     * @return the addonProfiles value.
     */
    public Map<String, ManagedClusterAddonProfile> addonProfiles() {
        return this.addonProfiles;
    }

    /**
     * Set the addonProfiles property: Profile of managed cluster add-on.
     *
     * @param addonProfiles the addonProfiles value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withAddonProfiles(
        Map<String, ManagedClusterAddonProfile> addonProfiles) {
        this.addonProfiles = addonProfiles;
        return this;
    }

    /**
     * Get the nodeResourceGroup property: Name of the resource group containing agent pool nodes.
     *
     * @return the nodeResourceGroup value.
     */
    public String nodeResourceGroup() {
        return this.nodeResourceGroup;
    }

    /**
     * Set the nodeResourceGroup property: Name of the resource group containing agent pool nodes.
     *
     * @param nodeResourceGroup the nodeResourceGroup value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withNodeResourceGroup(String nodeResourceGroup) {
        this.nodeResourceGroup = nodeResourceGroup;
        return this;
    }

    /**
     * Get the enableRbac property: Whether to enable Kubernetes Role-Based Access Control.
     *
     * @return the enableRbac value.
     */
    public Boolean enableRbac() {
        return this.enableRbac;
    }

    /**
     * Set the enableRbac property: Whether to enable Kubernetes Role-Based Access Control.
     *
     * @param enableRbac the enableRbac value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withEnableRbac(Boolean enableRbac) {
        this.enableRbac = enableRbac;
        return this;
    }

    /**
     * Get the enablePodSecurityPolicy property: (DEPRECATING) Whether to enable Kubernetes pod security policy
     * (preview). This feature is set for removal on October 15th, 2020. Learn more at aka.ms/aks/azpodpolicy.
     *
     * @return the enablePodSecurityPolicy value.
     */
    public Boolean enablePodSecurityPolicy() {
        return this.enablePodSecurityPolicy;
    }

    /**
     * Set the enablePodSecurityPolicy property: (DEPRECATING) Whether to enable Kubernetes pod security policy
     * (preview). This feature is set for removal on October 15th, 2020. Learn more at aka.ms/aks/azpodpolicy.
     *
     * @param enablePodSecurityPolicy the enablePodSecurityPolicy value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withEnablePodSecurityPolicy(Boolean enablePodSecurityPolicy) {
        this.enablePodSecurityPolicy = enablePodSecurityPolicy;
        return this;
    }

    /**
     * Get the networkProfile property: Profile of network configuration.
     *
     * @return the networkProfile value.
     */
    public ContainerServiceNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    /**
     * Set the networkProfile property: Profile of network configuration.
     *
     * @param networkProfile the networkProfile value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withNetworkProfile(
        ContainerServiceNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    /**
     * Get the aadProfile property: Profile of Azure Active Directory configuration.
     *
     * @return the aadProfile value.
     */
    public ManagedClusterAadProfile aadProfile() {
        return this.aadProfile;
    }

    /**
     * Set the aadProfile property: Profile of Azure Active Directory configuration.
     *
     * @param aadProfile the aadProfile value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withAadProfile(ManagedClusterAadProfile aadProfile) {
        this.aadProfile = aadProfile;
        return this;
    }

    /**
     * Get the autoScalerProfile property: Parameters to be applied to the cluster-autoscaler when enabled.
     *
     * @return the autoScalerProfile value.
     */
    public ManagedClusterPropertiesAutoScalerProfile autoScalerProfile() {
        return this.autoScalerProfile;
    }

    /**
     * Set the autoScalerProfile property: Parameters to be applied to the cluster-autoscaler when enabled.
     *
     * @param autoScalerProfile the autoScalerProfile value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withAutoScalerProfile(
        ManagedClusterPropertiesAutoScalerProfile autoScalerProfile) {
        this.autoScalerProfile = autoScalerProfile;
        return this;
    }

    /**
     * Get the apiServerAccessProfile property: Access profile for managed cluster API server.
     *
     * @return the apiServerAccessProfile value.
     */
    public ManagedClusterApiServerAccessProfile apiServerAccessProfile() {
        return this.apiServerAccessProfile;
    }

    /**
     * Set the apiServerAccessProfile property: Access profile for managed cluster API server.
     *
     * @param apiServerAccessProfile the apiServerAccessProfile value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withApiServerAccessProfile(
        ManagedClusterApiServerAccessProfile apiServerAccessProfile) {
        this.apiServerAccessProfile = apiServerAccessProfile;
        return this;
    }

    /**
     * Get the diskEncryptionSetId property: ResourceId of the disk encryption set to use for enabling encryption at
     * rest.
     *
     * @return the diskEncryptionSetId value.
     */
    public String diskEncryptionSetId() {
        return this.diskEncryptionSetId;
    }

    /**
     * Set the diskEncryptionSetId property: ResourceId of the disk encryption set to use for enabling encryption at
     * rest.
     *
     * @param diskEncryptionSetId the diskEncryptionSetId value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withDiskEncryptionSetId(String diskEncryptionSetId) {
        this.diskEncryptionSetId = diskEncryptionSetId;
        return this;
    }

    /**
     * Get the identityProfile property: Identities associated with the cluster.
     *
     * @return the identityProfile value.
     */
    public Map<String, UserAssignedIdentity> identityProfile() {
        return this.identityProfile;
    }

    /**
     * Set the identityProfile property: Identities associated with the cluster.
     *
     * @param identityProfile the identityProfile value to set.
     * @return the Components1Q1Og48SchemasManagedclusterAllof1 object itself.
     */
    public Components1Q1Og48SchemasManagedclusterAllof1 withIdentityProfile(
        Map<String, UserAssignedIdentity> identityProfile) {
        this.identityProfile = identityProfile;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
        if (agentPoolProfiles() != null) {
            agentPoolProfiles().forEach(e -> e.validate());
        }
        if (linuxProfile() != null) {
            linuxProfile().validate();
        }
        if (windowsProfile() != null) {
            windowsProfile().validate();
        }
        if (servicePrincipalProfile() != null) {
            servicePrincipalProfile().validate();
        }
        if (addonProfiles() != null) {
            addonProfiles()
                .values()
                .forEach(
                    e -> {
                        if (e != null) {
                            e.validate();
                        }
                    });
        }
        if (networkProfile() != null) {
            networkProfile().validate();
        }
        if (aadProfile() != null) {
            aadProfile().validate();
        }
        if (autoScalerProfile() != null) {
            autoScalerProfile().validate();
        }
        if (apiServerAccessProfile() != null) {
            apiServerAccessProfile().validate();
        }
        if (identityProfile() != null) {
            identityProfile()
                .values()
                .forEach(
                    e -> {
                        if (e != null) {
                            e.validate();
                        }
                    });
        }
    }
}
