// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Identity for the managed cluster. */
@Fluent
public class ManagedClusterIdentity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ManagedClusterIdentity.class);

    /*
     * The principal id of the system assigned identity which is used by master
     * components.
     */
    @JsonProperty(value = "principalId", access = JsonProperty.Access.WRITE_ONLY)
    private String principalId;

    /*
     * The tenant id of the system assigned identity which is used by master
     * components.
     */
    @JsonProperty(value = "tenantId", access = JsonProperty.Access.WRITE_ONLY)
    private String tenantId;

    /*
     * The type of identity used for the managed cluster. Type 'SystemAssigned'
     * will use an implicitly created identity in master components and an
     * auto-created user assigned identity in MC_ resource group in agent
     * nodes. Type 'None' will not use MSI for the managed cluster, service
     * principal will be used instead.
     */
    @JsonProperty(value = "type")
    private ResourceIdentityType type;

    /*
     * The user identity associated with the managed cluster. This identity
     * will be used in control plane and only one user assigned identity is
     * allowed. The user identity dictionary key references will be ARM
     * resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JsonProperty(value = "userAssignedIdentities")
    private Map<String, ManagedClusterIdentityUserAssignedIdentities> userAssignedIdentities;

    /**
     * Get the principalId property: The principal id of the system assigned identity which is used by master
     * components.
     *
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Get the tenantId property: The tenant id of the system assigned identity which is used by master components.
     *
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Get the type property: The type of identity used for the managed cluster. Type 'SystemAssigned' will use an
     * implicitly created identity in master components and an auto-created user assigned identity in MC_ resource group
     * in agent nodes. Type 'None' will not use MSI for the managed cluster, service principal will be used instead.
     *
     * @return the type value.
     */
    public ResourceIdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of identity used for the managed cluster. Type 'SystemAssigned' will use an
     * implicitly created identity in master components and an auto-created user assigned identity in MC_ resource group
     * in agent nodes. Type 'None' will not use MSI for the managed cluster, service principal will be used instead.
     *
     * @param type the type value to set.
     * @return the ManagedClusterIdentity object itself.
     */
    public ManagedClusterIdentity withType(ResourceIdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the userAssignedIdentities property: The user identity associated with the managed cluster. This identity
     * will be used in control plane and only one user assigned identity is allowed. The user identity dictionary key
     * references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     *
     * @return the userAssignedIdentities value.
     */
    public Map<String, ManagedClusterIdentityUserAssignedIdentities> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    /**
     * Set the userAssignedIdentities property: The user identity associated with the managed cluster. This identity
     * will be used in control plane and only one user assigned identity is allowed. The user identity dictionary key
     * references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     *
     * @param userAssignedIdentities the userAssignedIdentities value to set.
     * @return the ManagedClusterIdentity object itself.
     */
    public ManagedClusterIdentity withUserAssignedIdentities(
        Map<String, ManagedClusterIdentityUserAssignedIdentities> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (userAssignedIdentities() != null) {
            userAssignedIdentities()
                .values()
                .forEach(
                    e -> {
                        if (e != null) {
                            e.validate();
                        }
                    });
        }
    }
}
