// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for ManagedClusterSkuTier. */
public final class ManagedClusterSkuTier extends ExpandableStringEnum<ManagedClusterSkuTier> {
    /** Static value Paid for ManagedClusterSkuTier. */
    public static final ManagedClusterSkuTier PAID = fromString("Paid");

    /** Static value Free for ManagedClusterSkuTier. */
    public static final ManagedClusterSkuTier FREE = fromString("Free");

    /**
     * Creates or finds a ManagedClusterSkuTier from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ManagedClusterSkuTier.
     */
    @JsonCreator
    public static ManagedClusterSkuTier fromString(String name) {
        return fromString(name, ManagedClusterSkuTier.class);
    }

    /** @return known ManagedClusterSkuTier values. */
    public static Collection<ManagedClusterSkuTier> values() {
        return values(ManagedClusterSkuTier.class);
    }
}
