/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicelinker.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.servicelinker.ServiceLinkerManager;
import com.azure.resourcemanager.servicelinker.fluent.models.LinkerResourceInner;
import com.azure.resourcemanager.servicelinker.implementation.Utils;
import com.azure.resourcemanager.servicelinker.models.AuthInfoBase;
import com.azure.resourcemanager.servicelinker.models.ClientType;
import com.azure.resourcemanager.servicelinker.models.LinkerPatch;
import com.azure.resourcemanager.servicelinker.models.LinkerResource;
import com.azure.resourcemanager.servicelinker.models.SecretStore;
import com.azure.resourcemanager.servicelinker.models.SourceConfigurationResult;
import com.azure.resourcemanager.servicelinker.models.TargetServiceBase;
import com.azure.resourcemanager.servicelinker.models.VNetSolution;
import com.azure.resourcemanager.servicelinker.models.ValidateOperationResult;

public final class LinkerResourceImpl
implements LinkerResource,
LinkerResource.Definition,
LinkerResource.Update {
    private LinkerResourceInner innerObject;
    private final ServiceLinkerManager serviceManager;
    private String resourceUri;
    private String linkerName;
    private LinkerPatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public TargetServiceBase targetService() {
        return this.innerModel().targetService();
    }

    @Override
    public AuthInfoBase authInfo() {
        return this.innerModel().authInfo();
    }

    @Override
    public ClientType clientType() {
        return this.innerModel().clientType();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public VNetSolution vNetSolution() {
        return this.innerModel().vNetSolution();
    }

    @Override
    public SecretStore secretStore() {
        return this.innerModel().secretStore();
    }

    @Override
    public String scope() {
        return this.innerModel().scope();
    }

    @Override
    public LinkerResourceInner innerModel() {
        return this.innerObject;
    }

    private ServiceLinkerManager manager() {
        return this.serviceManager;
    }

    @Override
    public LinkerResourceImpl withExistingResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
        return this;
    }

    @Override
    public LinkerResource create() {
        this.innerObject = this.serviceManager.serviceClient().getLinkers().createOrUpdate(this.resourceUri, this.linkerName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public LinkerResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getLinkers().createOrUpdate(this.resourceUri, this.linkerName, this.innerModel(), context);
        return this;
    }

    LinkerResourceImpl(String name, ServiceLinkerManager serviceManager) {
        this.innerObject = new LinkerResourceInner();
        this.serviceManager = serviceManager;
        this.linkerName = name;
    }

    @Override
    public LinkerResourceImpl update() {
        this.updateParameters = new LinkerPatch();
        return this;
    }

    @Override
    public LinkerResource apply() {
        this.innerObject = this.serviceManager.serviceClient().getLinkers().update(this.resourceUri, this.linkerName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public LinkerResource apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getLinkers().update(this.resourceUri, this.linkerName, this.updateParameters, context);
        return this;
    }

    LinkerResourceImpl(LinkerResourceInner innerObject, ServiceLinkerManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceUri = Utils.getValueFromIdByParameterName(innerObject.id(), "/{resourceUri}/providers/Microsoft.ServiceLinker/linkers/{linkerName}", "resourceUri");
        this.linkerName = Utils.getValueFromIdByParameterName(innerObject.id(), "/{resourceUri}/providers/Microsoft.ServiceLinker/linkers/{linkerName}", "linkerName");
    }

    @Override
    public LinkerResource refresh() {
        this.innerObject = (LinkerResourceInner)((Object)this.serviceManager.serviceClient().getLinkers().getWithResponse(this.resourceUri, this.linkerName, Context.NONE).getValue());
        return this;
    }

    @Override
    public LinkerResource refresh(Context context) {
        this.innerObject = (LinkerResourceInner)((Object)this.serviceManager.serviceClient().getLinkers().getWithResponse(this.resourceUri, this.linkerName, context).getValue());
        return this;
    }

    @Override
    public ValidateOperationResult validate() {
        return this.serviceManager.linkers().validate(this.resourceUri, this.linkerName);
    }

    @Override
    public ValidateOperationResult validate(Context context) {
        return this.serviceManager.linkers().validate(this.resourceUri, this.linkerName, context);
    }

    @Override
    public SourceConfigurationResult listConfigurations() {
        return this.serviceManager.linkers().listConfigurations(this.resourceUri, this.linkerName);
    }

    @Override
    public Response<SourceConfigurationResult> listConfigurationsWithResponse(Context context) {
        return this.serviceManager.linkers().listConfigurationsWithResponse(this.resourceUri, this.linkerName, context);
    }

    @Override
    public LinkerResourceImpl withTargetService(TargetServiceBase targetService) {
        if (this.isInCreateMode()) {
            this.innerModel().withTargetService(targetService);
            return this;
        }
        this.updateParameters.withTargetService(targetService);
        return this;
    }

    @Override
    public LinkerResourceImpl withAuthInfo(AuthInfoBase authInfo) {
        if (this.isInCreateMode()) {
            this.innerModel().withAuthInfo(authInfo);
            return this;
        }
        this.updateParameters.withAuthInfo(authInfo);
        return this;
    }

    @Override
    public LinkerResourceImpl withClientType(ClientType clientType) {
        if (this.isInCreateMode()) {
            this.innerModel().withClientType(clientType);
            return this;
        }
        this.updateParameters.withClientType(clientType);
        return this;
    }

    @Override
    public LinkerResourceImpl withVNetSolution(VNetSolution vNetSolution) {
        if (this.isInCreateMode()) {
            this.innerModel().withVNetSolution(vNetSolution);
            return this;
        }
        this.updateParameters.withVNetSolution(vNetSolution);
        return this;
    }

    @Override
    public LinkerResourceImpl withSecretStore(SecretStore secretStore) {
        if (this.isInCreateMode()) {
            this.innerModel().withSecretStore(secretStore);
            return this;
        }
        this.updateParameters.withSecretStore(secretStore);
        return this;
    }

    @Override
    public LinkerResourceImpl withScope(String scope) {
        if (this.isInCreateMode()) {
            this.innerModel().withScope(scope);
            return this;
        }
        this.updateParameters.withScope(scope);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

