/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicelinker.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.servicelinker.fluent.models.LinkerResourceInner;
import com.azure.resourcemanager.servicelinker.models.AuthInfoBase;
import com.azure.resourcemanager.servicelinker.models.ClientType;
import com.azure.resourcemanager.servicelinker.models.SecretStore;
import com.azure.resourcemanager.servicelinker.models.SourceConfigurationResult;
import com.azure.resourcemanager.servicelinker.models.TargetServiceBase;
import com.azure.resourcemanager.servicelinker.models.VNetSolution;
import com.azure.resourcemanager.servicelinker.models.ValidateOperationResult;

public interface LinkerResource {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public TargetServiceBase targetService();

    public AuthInfoBase authInfo();

    public ClientType clientType();

    public String provisioningState();

    public VNetSolution vNetSolution();

    public SecretStore secretStore();

    public String scope();

    public LinkerResourceInner innerModel();

    public Update update();

    public LinkerResource refresh();

    public LinkerResource refresh(Context var1);

    public ValidateOperationResult validate();

    public ValidateOperationResult validate(Context var1);

    public SourceConfigurationResult listConfigurations();

    public Response<SourceConfigurationResult> listConfigurationsWithResponse(Context var1);

    public static interface UpdateStages {

        public static interface WithScope {
            public Update withScope(String var1);
        }

        public static interface WithSecretStore {
            public Update withSecretStore(SecretStore var1);
        }

        public static interface WithVNetSolution {
            public Update withVNetSolution(VNetSolution var1);
        }

        public static interface WithClientType {
            public Update withClientType(ClientType var1);
        }

        public static interface WithAuthInfo {
            public Update withAuthInfo(AuthInfoBase var1);
        }

        public static interface WithTargetService {
            public Update withTargetService(TargetServiceBase var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTargetService,
    UpdateStages.WithAuthInfo,
    UpdateStages.WithClientType,
    UpdateStages.WithVNetSolution,
    UpdateStages.WithSecretStore,
    UpdateStages.WithScope {
        public LinkerResource apply();

        public LinkerResource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithScope {
            public WithCreate withScope(String var1);
        }

        public static interface WithSecretStore {
            public WithCreate withSecretStore(SecretStore var1);
        }

        public static interface WithVNetSolution {
            public WithCreate withVNetSolution(VNetSolution var1);
        }

        public static interface WithClientType {
            public WithCreate withClientType(ClientType var1);
        }

        public static interface WithAuthInfo {
            public WithCreate withAuthInfo(AuthInfoBase var1);
        }

        public static interface WithTargetService {
            public WithCreate withTargetService(TargetServiceBase var1);
        }

        public static interface WithCreate
        extends WithTargetService,
        WithAuthInfo,
        WithClientType,
        WithVNetSolution,
        WithSecretStore,
        WithScope {
            public LinkerResource create();

            public LinkerResource create(Context var1);
        }

        public static interface WithScopeStage {
            public WithCreate withExistingResourceUri(String var1);
        }

        public static interface Blank
        extends WithScopeStage {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithScopeStage,
    DefinitionStages.WithCreate {
    }
}

