/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.filter;

import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadAuthenticationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.constants.Constants;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.graph.Membership;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.graph.Memberships;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.properties.AadAuthorizationServerEndpoints;
import com.azure.spring.cloud.autoconfigure.implementation.aad.utils.AadRestTemplateCreator;
import com.azure.spring.cloud.autoconfigure.implementation.aad.utils.JacksonObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.MsalServiceException;
import com.microsoft.aad.msal4j.OnBehalfOfParameters;
import com.microsoft.aad.msal4j.UserAssertion;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.naming.ServiceUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

class AadGraphClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AadGraphClient.class);
    private static final String MICROSOFT_GRAPH_SCOPE = "User.Read";
    private static final String REQUEST_ID_SUFFIX = "aadfeed6";
    private final String clientId;
    private final String clientSecret;
    private final AadAuthorizationServerEndpoints endpoints;
    private final AadAuthenticationProperties aadAuthenticationProperties;
    private RestOperations operations;

    AadGraphClient(String clientId, String clientSecret, AadAuthenticationProperties aadAuthenticationProperties, AadAuthorizationServerEndpoints endpoints, RestTemplateBuilder restTemplateBuilder) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.aadAuthenticationProperties = aadAuthenticationProperties;
        this.endpoints = endpoints;
        this.operations = AadRestTemplateCreator.createRestTemplate(restTemplateBuilder);
    }

    void setRestOperations(RestOperations operations) {
        this.operations = operations;
    }

    private String getUserMemberships(String accessToken, String urlString) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", String.format("Bearer %s", accessToken));
        headers.set("Accept", "application/json");
        headers.set("Content-Type", "application/x-www-form-urlencoded");
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.operations.exchange(urlString, HttpMethod.GET, entity, String.class, new Object[0]);
        String responseInJson = (String)response.getBody();
        if (response.getStatusCode() == HttpStatus.OK) {
            return (String)response.getBody();
        }
        throw new IllegalStateException("Response is not " + HttpStatus.OK + ", response json: " + responseInJson);
    }

    public Set<String> getGroups(String graphApiToken) throws IOException {
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        ObjectMapper objectMapper = JacksonObjectMapperFactory.getInstance();
        String aadMembershipRestUri = this.aadAuthenticationProperties.getGraphMembershipUri();
        while (aadMembershipRestUri != null) {
            String membershipsJson = this.getUserMemberships(graphApiToken, aadMembershipRestUri);
            Memberships memberships = (Memberships)objectMapper.readValue(membershipsJson, Memberships.class);
            memberships.getValue().stream().filter(this::isGroupObject).map(Membership::getDisplayName).forEach(groups::add);
            aadMembershipRestUri = Optional.of(memberships).map(Memberships::getOdataNextLink).orElse(null);
        }
        return groups;
    }

    private boolean isGroupObject(Membership membership) {
        return membership.getObjectType().equals("#microsoft.graph.group");
    }

    public Set<SimpleGrantedAuthority> toGrantedAuthoritySet(Set<String> groups) {
        Set grantedAuthoritySet = groups.stream().filter(this.aadAuthenticationProperties::isAllowedGroup).map(group -> new SimpleGrantedAuthority("ROLE_" + group)).collect(Collectors.toSet());
        return Optional.of(grantedAuthoritySet).filter(g -> !g.isEmpty()).orElse(Constants.DEFAULT_AUTHORITY_SET);
    }

    public IAuthenticationResult acquireTokenForGraphApi(String idToken, String tenantId) throws ServiceUnavailableException {
        IClientSecret clientCredential = ClientCredentialFactory.createFromSecret((String)this.clientSecret);
        UserAssertion assertion = new UserAssertion(idToken);
        IAuthenticationResult result = null;
        try {
            ConfidentialClientApplication application = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)clientCredential).authority(this.endpoints.getBaseUri() + tenantId + "/")).correlationId(AadGraphClient.getCorrelationId())).build();
            HashSet<String> scopes = new HashSet<String>();
            scopes.add(MICROSOFT_GRAPH_SCOPE);
            OnBehalfOfParameters onBehalfOfParameters = OnBehalfOfParameters.builder(scopes, (UserAssertion)assertion).build();
            result = (IAuthenticationResult)application.acquireToken(onBehalfOfParameters).get();
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted during acquiring token for graph API!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (MalformedURLException | ExecutionException e) {
            MsalServiceException exception;
            Throwable cause = e.getCause();
            if (cause instanceof MsalServiceException && (exception = (MsalServiceException)cause).claims() != null && !exception.claims().isEmpty()) {
                throw exception;
            }
            LOGGER.error("acquire on behalf of token for graph api error", (Throwable)e);
        }
        if (result == null) {
            throw new ServiceUnavailableException("unable to acquire on_behalf_of token for client " + this.clientId);
        }
        return result;
    }

    private static String getCorrelationId() {
        String uuid = UUID.randomUUID().toString();
        return uuid.substring(0, uuid.length() - REQUEST_ID_SUFFIX.length()) + REQUEST_ID_SUFFIX;
    }
}

