/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.converter;

import com.azure.core.amqp.AmqpRetryMode;
import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.provider.RetryOptionsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public final class AzureAmqpRetryOptionsConverter
implements Converter<RetryOptionsProvider.AmqpRetryOptions, AmqpRetryOptions> {
    public static final AzureAmqpRetryOptionsConverter AMQP_RETRY_CONVERTER = new AzureAmqpRetryOptionsConverter();
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureAmqpRetryOptionsConverter.class);

    private AzureAmqpRetryOptionsConverter() {
    }

    public AmqpRetryOptions convert(RetryOptionsProvider.AmqpRetryOptions retry) {
        PropertyMapper mapper = new PropertyMapper();
        RetryOptionsProvider.RetryMode retryMode = retry.getMode();
        if (RetryOptionsProvider.RetryMode.EXPONENTIAL.equals((Object)retryMode)) {
            RetryOptionsProvider.RetryOptions.ExponentialRetryOptions exponential = retry.getExponential();
            if (exponential != null && exponential.getMaxRetries() != null) {
                AmqpRetryOptions result = new AmqpRetryOptions();
                result.setMode(AmqpRetryMode.EXPONENTIAL);
                mapper.from(retry.getTryTimeout()).to(arg_0 -> ((AmqpRetryOptions)result).setTryTimeout(arg_0));
                mapper.from(exponential.getMaxRetries()).to(arg_0 -> ((AmqpRetryOptions)result).setMaxRetries(arg_0));
                mapper.from(exponential.getBaseDelay()).to(arg_0 -> ((AmqpRetryOptions)result).setDelay(arg_0));
                mapper.from(exponential.getMaxDelay()).to(arg_0 -> ((AmqpRetryOptions)result).setMaxDelay(arg_0));
                return result;
            }
            LOGGER.debug("The max-retries is not set, skip the convert.");
        } else if (RetryOptionsProvider.RetryMode.FIXED.equals((Object)retryMode)) {
            RetryOptionsProvider.RetryOptions.FixedRetryOptions fixed = retry.getFixed();
            if (fixed != null && fixed.getMaxRetries() != null) {
                AmqpRetryOptions result = new AmqpRetryOptions();
                result.setMode(AmqpRetryMode.FIXED);
                mapper.from(retry.getTryTimeout()).to(arg_0 -> ((AmqpRetryOptions)result).setTryTimeout(arg_0));
                mapper.from(fixed.getMaxRetries()).to(arg_0 -> ((AmqpRetryOptions)result).setMaxRetries(arg_0));
                mapper.from(fixed.getDelay()).to(arg_0 -> ((AmqpRetryOptions)result).setDelay(arg_0));
                return result;
            }
            LOGGER.debug("The max-retries is not set, skip the convert.");
        }
        return null;
    }
}

