/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.factory.credential;

import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.spring.cloud.core.implementation.factory.credential.AbstractAzureCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.AzureProfileOptionsProvider;
import java.util.concurrent.ExecutorService;

public class DefaultAzureCredentialBuilderFactory
extends AbstractAzureCredentialBuilderFactory<DefaultAzureCredentialBuilder> {
    private ExecutorService executorService = null;

    public DefaultAzureCredentialBuilderFactory(AzureProperties azureProperties) {
        super(azureProperties);
    }

    @Override
    protected DefaultAzureCredentialBuilder createBuilderInstance() {
        return new DefaultAzureCredentialBuilder();
    }

    @Override
    protected void configureService(DefaultAzureCredentialBuilder builder) {
        AzureProperties azureProperties = this.getAzureProperties();
        AzureProfileOptionsProvider.ProfileOptions profile = azureProperties.getProfile();
        PropertyMapper mapper = new PropertyMapper();
        mapper.from(profile.getTenantId()).to(arg_0 -> ((DefaultAzureCredentialBuilder)builder).tenantId(arg_0));
        mapper.from(profile.getEnvironment().getActiveDirectoryEndpoint()).to(arg_0 -> ((DefaultAzureCredentialBuilder)builder).authorityHost(arg_0));
        mapper.from(azureProperties.getCredential().getClientId()).when(p -> azureProperties.getCredential().isManagedIdentityEnabled()).to(arg_0 -> ((DefaultAzureCredentialBuilder)builder).managedIdentityClientId(arg_0));
        mapper.from(this.executorService).to(arg_0 -> ((DefaultAzureCredentialBuilder)builder).executorService(arg_0));
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

