/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.trace;

import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureHttpClientBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class AzureHttpClientBuilderFactoryBeanPostProcessor
implements BeanPostProcessor,
Ordered,
BeanFactoryAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureHttpClientBuilderFactoryBeanPostProcessor.class);
    private final String httpPolicyBeanName;
    private BeanFactory beanFactory;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public AzureHttpClientBuilderFactoryBeanPostProcessor(String httpPolicyBeanName) {
        this.httpPolicyBeanName = httpPolicyBeanName;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!(bean instanceof AbstractAzureHttpClientBuilderFactory)) {
            return bean;
        }
        if (this.beanFactory.containsBean(this.httpPolicyBeanName)) {
            HttpPipelinePolicy policy = (HttpPipelinePolicy)this.beanFactory.getBean(this.httpPolicyBeanName);
            AbstractAzureHttpClientBuilderFactory builderFactory = (AbstractAzureHttpClientBuilderFactory)bean;
            builderFactory.addHttpPipelinePolicy(policy);
            LOGGER.debug("Added the Sleuth http pipeline policy to {} builder.", bean.getClass());
        }
        return bean;
    }
}

