/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.provider;

import com.azure.core.amqp.AmqpTransportType;
import com.azure.spring.cloud.core.properties.client.HeaderProperties;
import com.azure.spring.cloud.core.provider.HttpLoggingOptionsProvider;
import java.time.Duration;
import java.util.List;

public interface ClientOptionsProvider {
    public ClientOptions getClient();

    public static interface AmqpClientOptions
    extends ClientOptions {
        public AmqpTransportType getTransportType();
    }

    public static interface HttpClientOptions
    extends ClientOptions,
    HttpLoggingOptionsProvider {
        public Duration getWriteTimeout();

        public Duration getResponseTimeout();

        public Duration getReadTimeout();

        public Duration getConnectTimeout();

        public Integer getMaximumConnectionPoolSize();

        public Duration getConnectionIdleTimeout();

        public List<HeaderProperties> getHeaders();
    }

    public static interface ClientOptions {
        public String getApplicationId();
    }
}

