/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.resource;

import com.azure.spring.cloud.core.resource.AzureStorageUtils;
import com.azure.spring.cloud.core.resource.StorageType;
import java.net.URLConnection;
import java.util.Locale;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.WritableResource;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class AzureStorageResource
extends AbstractResource
implements WritableResource {
    private static final String PATH_DELIMITER = "/";

    AzureStorageResource() {
    }

    private boolean isAzureStorageResource(@NonNull String location) {
        Assert.hasText((String)location, (String)"Location must not be null or empty");
        return location.toLowerCase(Locale.ROOT).startsWith(this.getProtocolPrefix());
    }

    String getContainerName(String location) {
        this.assertIsAzureStorageLocation(location);
        int containerEndIndex = this.assertContainerValid(location);
        return location.substring(this.getProtocolPrefix().length(), containerEndIndex);
    }

    String getContentType(String location) {
        String objectName = this.getFilename(location);
        if (StringUtils.hasText((String)objectName)) {
            return URLConnection.guessContentTypeFromName(objectName);
        }
        return null;
    }

    String getFilename(String location) {
        this.assertIsAzureStorageLocation(location);
        int containerEndIndex = this.assertContainerValid(location);
        if (location.endsWith(PATH_DELIMITER)) {
            return location.substring(++containerEndIndex, location.length() - 1);
        }
        return location.substring(++containerEndIndex);
    }

    void assertIsAzureStorageLocation(String location) {
        if (!this.isAzureStorageResource(location)) {
            throw new IllegalArgumentException(String.format("The location '%s' is not a valid Azure storage location", location));
        }
    }

    private int assertContainerValid(String location) {
        int containerEndIndex = location.indexOf(PATH_DELIMITER, this.getProtocolPrefix().length());
        if (containerEndIndex == -1 || containerEndIndex == this.getProtocolPrefix().length()) {
            throw new IllegalArgumentException(String.format("The location '%s' does not contain a valid container name", location));
        }
        return containerEndIndex;
    }

    private String getProtocolPrefix() {
        return AzureStorageUtils.getStorageProtocolPrefix(this.getStorageType());
    }

    abstract StorageType getStorageType();
}

