/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.factory.credential;

import com.azure.identity.UsernamePasswordCredentialBuilder;
import com.azure.spring.cloud.core.implementation.factory.credential.AzureAadCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.authentication.TokenCredentialOptionsProvider;

public class UsernamePasswordCredentialBuilderFactory
extends AzureAadCredentialBuilderFactory<UsernamePasswordCredentialBuilder> {
    public UsernamePasswordCredentialBuilderFactory(AzureProperties azureProperties) {
        super(azureProperties);
    }

    @Override
    protected UsernamePasswordCredentialBuilder createBuilderInstance() {
        return new UsernamePasswordCredentialBuilder();
    }

    @Override
    protected void configureService(UsernamePasswordCredentialBuilder builder) {
        super.configureService(builder);
        AzureProperties azureProperties = this.getAzureProperties();
        TokenCredentialOptionsProvider.TokenCredentialOptions credential = azureProperties.getCredential();
        PropertyMapper map = new PropertyMapper();
        map.from(credential.getUsername()).to(arg_0 -> ((UsernamePasswordCredentialBuilder)builder).username(arg_0));
        map.from(credential.getPassword()).to(arg_0 -> ((UsernamePasswordCredentialBuilder)builder).password(arg_0));
    }
}

