/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client;

import com.basho.riak.client.DefaultRiakClient;
import com.basho.riak.client.IRiakClient;
import com.basho.riak.client.NoFactoryForConfigException;
import com.basho.riak.client.RiakException;
import com.basho.riak.client.http.RiakClient;
import com.basho.riak.client.raw.RiakClientFactory;
import com.basho.riak.client.raw.config.Configuration;
import com.basho.riak.client.raw.http.HTTPClientAdapter;
import com.basho.riak.client.raw.http.HTTPClientConfig;
import com.basho.riak.client.raw.http.HTTPClusterClientFactory;
import com.basho.riak.client.raw.http.HTTPClusterConfig;
import com.basho.riak.client.raw.http.HTTPRiakClientFactory;
import com.basho.riak.client.raw.pbc.PBClientAdapter;
import com.basho.riak.client.raw.pbc.PBClientConfig;
import com.basho.riak.client.raw.pbc.PBClusterClientFactory;
import com.basho.riak.client.raw.pbc.PBClusterConfig;
import com.basho.riak.client.raw.pbc.PBRiakClientFactory;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

public class RiakFactory {
    private static final ConcurrentHashMap<Class<? extends Configuration>, RiakClientFactory> REGISTRY = new ConcurrentHashMap(3);
    private static final String DEFAULT_RIAK_URL = "http://127.0.0.1:8098/riak";

    public static IRiakClient pbcClient() throws RiakException {
        try {
            PBClientAdapter client = new PBClientAdapter("127.0.0.1", 8087);
            return new DefaultRiakClient(client);
        }
        catch (IOException e) {
            throw new RiakException(e);
        }
    }

    public static IRiakClient pbcClient(String host, int port) throws RiakException {
        try {
            PBClientAdapter client = new PBClientAdapter(host, port);
            return new DefaultRiakClient(client);
        }
        catch (IOException e) {
            throw new RiakException(e);
        }
    }

    public static IRiakClient pbcClient(com.basho.riak.pbc.RiakClient delegate) {
        PBClientAdapter client = new PBClientAdapter(delegate);
        return new DefaultRiakClient(client);
    }

    public static IRiakClient httpClient() throws RiakException {
        HTTPClientAdapter client = new HTTPClientAdapter(DEFAULT_RIAK_URL);
        return new DefaultRiakClient(client);
    }

    public static IRiakClient httpClient(String url) throws RiakException {
        HTTPClientAdapter client = new HTTPClientAdapter(url);
        return new DefaultRiakClient(client);
    }

    public static IRiakClient httpClient(RiakClient delegate) throws RiakException {
        HTTPClientAdapter client = new HTTPClientAdapter(delegate);
        return new DefaultRiakClient(client);
    }

    public static IRiakClient newClient(Configuration config) throws RiakException {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        RiakClientFactory fac = RiakFactory.getFactory(config);
        try {
            return new DefaultRiakClient(fac.newClient(config));
        }
        catch (IOException e) {
            throw new RiakException(e);
        }
    }

    private static RiakClientFactory getFactory(Configuration config) {
        RiakClientFactory fac = REGISTRY.get(config.getClass());
        if (fac == null) {
            throw new NoFactoryForConfigException(config.getClass());
        }
        return fac;
    }

    static {
        REGISTRY.put(HTTPClientConfig.class, HTTPRiakClientFactory.getInstance());
        REGISTRY.put(PBClientConfig.class, PBRiakClientFactory.getInstance());
        REGISTRY.put(PBClusterConfig.class, PBClusterClientFactory.getInstance());
        REGISTRY.put(HTTPClusterConfig.class, HTTPClusterClientFactory.getInstance());
    }
}

