/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;

public class RiakConfig {
    public static Pattern BASE_URL_PATTERN = Pattern.compile("^((?:[^:]*://)?[^/]*)");
    private String url = null;
    private String baseUrl = null;
    private String mapredPath = "/mapred";
    private String pingPath = "/ping";
    private String statsPath = "/stats";
    private HttpClient httpClient = null;
    private Integer timeout = null;
    private Integer maxConnections = null;
    private HttpRequestRetryHandler retryHandler = null;

    public RiakConfig() {
    }

    public RiakConfig(String url) {
        if (url == null || url.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.setUrl(url);
    }

    public RiakConfig(URL url) {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        String protocol = url.getProtocol().toLowerCase();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new IllegalArgumentException();
        }
        this.setUrl(url.toExternalForm());
    }

    public RiakConfig(String ip, String port, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this.setUrl("http://" + ip + ":" + port + prefix);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        Matcher m = BASE_URL_PATTERN.matcher(url);
        this.baseUrl = m.find() ? m.group() : this.url;
    }

    public String getMapReduceUrl() {
        return this.baseUrl + this.mapredPath;
    }

    public String getPingUrl() {
        return this.baseUrl + this.pingPath;
    }

    public String getStatsUrl() {
        return this.baseUrl + this.statsPath;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getMapReducePath() {
        return this.mapredPath;
    }

    public void setMapReducePath(String path) {
        this.mapredPath = this.cleanUpPath(path);
    }

    public String getPingPath() {
        return this.pingPath;
    }

    public void setPingPath(String path) {
        this.pingPath = this.cleanUpPath(path);
    }

    private String cleanUpPath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public HttpRequestRetryHandler getRetryHandler() {
        return this.retryHandler;
    }

    public void setRetryHandler(HttpRequestRetryHandler retryHandler) {
        this.retryHandler = retryHandler;
    }
}

