/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http.util;

import com.basho.riak.client.http.RiakConfig;
import com.basho.riak.client.http.RiakObject;
import com.basho.riak.client.http.request.RequestMeta;
import com.basho.riak.client.http.response.DefaultHttpResponse;
import com.basho.riak.client.http.response.RiakExceptionHandler;
import com.basho.riak.client.http.response.RiakIORuntimeException;
import com.basho.riak.client.http.response.RiakResponseRuntimeException;
import com.basho.riak.client.http.response.StreamHandler;
import com.basho.riak.client.http.util.ClientUtils;
import com.basho.riak.client.util.CharsetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class ClientHelper {
    private RiakConfig config;
    private HttpClient httpClient;
    private String clientId = null;
    private RiakExceptionHandler exceptionHandler = null;

    public ClientHelper(RiakConfig config, String clientId) {
        this.config = config;
        this.httpClient = ClientUtils.newHttpClient(config);
        this.setClientId(clientId);
    }

    void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public byte[] getClientId() {
        return Base64.decodeBase64((byte[])CharsetUtils.utf8StringToBytes(this.clientId));
    }

    public void setClientId(String clientId) {
        this.clientId = clientId != null ? ClientUtils.encodeClientId(clientId) : ClientUtils.randomClientId();
    }

    public com.basho.riak.client.http.response.HttpResponse setBucketSchema(String bucket, JSONObject schema, RequestMeta meta) {
        if (schema == null) {
            schema = new JSONObject();
        }
        if (meta == null) {
            meta = new RequestMeta();
        }
        meta.setHeader("accept", "application/json");
        HttpPut put = new HttpPut(ClientUtils.makeURI(this.config, bucket));
        ByteArrayEntity entity = new ByteArrayEntity(CharsetUtils.utf8StringToBytes(schema.toString()));
        entity.setContentType("application/json; charset=UTF-8");
        put.setEntity((HttpEntity)entity);
        return this.executeMethod(bucket, null, (HttpRequestBase)put, meta);
    }

    public com.basho.riak.client.http.response.HttpResponse getBucketSchema(String bucket, RequestMeta meta) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getQueryParam("keys") == null) {
            meta.setQueryParam("keys", "false");
        }
        return this.listBucket(bucket, meta, false);
    }

    public com.basho.riak.client.http.response.HttpResponse listBuckets() {
        RequestMeta meta = new RequestMeta();
        meta.setQueryParam("buckets", "true");
        HttpGet get = new HttpGet(this.config.getUrl());
        return this.executeMethod(null, null, (HttpRequestBase)get, meta);
    }

    public com.basho.riak.client.http.response.HttpResponse listBucket(String bucket, RequestMeta meta, boolean streamResponse) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getQueryParam("keys") == null) {
            if (streamResponse) {
                meta.setQueryParam("keys", "stream");
            } else {
                meta.setQueryParam("keys", "true");
            }
        }
        if (meta.getHeader("content-type") == null) {
            meta.setHeader("content-type", "application/json");
        }
        if (meta.getHeader("accept") == null) {
            meta.setHeader("accept", "application/json");
        }
        HttpGet get = new HttpGet(ClientUtils.makeURI(this.config, bucket));
        return this.executeMethod(bucket, null, (HttpRequestBase)get, meta, streamResponse);
    }

    public com.basho.riak.client.http.response.HttpResponse store(RiakObject object, RequestMeta meta) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        if (meta.getClientId() == null) {
            meta.setClientId(this.clientId);
        }
        if (meta.getHeader("connection") == null) {
            meta.setHeader("connection", "keep-alive");
        }
        String bucket = object.getBucket();
        String key = object.getKey();
        String url = ClientUtils.makeURI(this.config, bucket, key);
        HttpRequestBase storeMethod = this.createStoreHttpMethod(key, url);
        object.writeToHttpMethod(storeMethod);
        return this.executeMethod(bucket, key, storeMethod, meta);
    }

    public com.basho.riak.client.http.response.HttpResponse fetchMeta(String bucket, String key, RequestMeta meta) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        HttpHead head = new HttpHead(ClientUtils.makeURI(this.config, bucket, key));
        return this.executeMethod(bucket, key, (HttpRequestBase)head, meta);
    }

    public com.basho.riak.client.http.response.HttpResponse fetch(String bucket, String key, RequestMeta meta, boolean streamResponse) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        HttpGet get = new HttpGet(ClientUtils.makeURI(this.config, bucket, key));
        return this.executeMethod(bucket, key, (HttpRequestBase)get, meta, streamResponse);
    }

    public com.basho.riak.client.http.response.HttpResponse fetch(String bucket, String key, RequestMeta meta) {
        return this.fetch(bucket, key, meta, false);
    }

    public boolean stream(String bucket, String key, StreamHandler handler, RequestMeta meta) throws IOException {
        if (meta == null) {
            meta = new RequestMeta();
        }
        HttpGet get = new HttpGet(ClientUtils.makeURI(this.config, bucket, key));
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            boolean result = true;
            if (handler != null) {
                result = handler.process(bucket, key, response.getStatusLine().getStatusCode(), ClientUtils.asHeaderMap(response.getAllHeaders()), entity.getContent(), response);
            }
            EntityUtils.consume((HttpEntity)entity);
            return result;
        }
        catch (IOException e) {
            get.abort();
            throw e;
        }
    }

    public com.basho.riak.client.http.response.HttpResponse delete(String bucket, String key, RequestMeta meta) {
        if (meta == null) {
            meta = new RequestMeta();
        }
        String url = ClientUtils.makeURI(this.config, bucket, key);
        HttpDelete delete = new HttpDelete(url);
        return this.executeMethod(bucket, key, (HttpRequestBase)delete, meta);
    }

    public com.basho.riak.client.http.response.HttpResponse walk(String bucket, String key, String walkSpec, RequestMeta meta) {
        HttpGet get = new HttpGet(ClientUtils.makeURI(this.config, bucket, key, walkSpec));
        return this.executeMethod(bucket, key, (HttpRequestBase)get, meta);
    }

    public com.basho.riak.client.http.response.HttpResponse mapReduce(String job, RequestMeta meta) {
        HttpPost post = new HttpPost(this.config.getMapReduceUrl());
        StringEntity entity = new StringEntity(job, ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)entity);
        return this.executeMethod(null, null, (HttpRequestBase)post, meta);
    }

    public com.basho.riak.client.http.response.HttpResponse fetchIndex(String bucket, String indexName, String[] values) {
        HttpGet get = new HttpGet(ClientUtils.makeURI(this.config, bucket, indexName, values));
        return this.executeMethod(bucket, null, (HttpRequestBase)get, null);
    }

    public com.basho.riak.client.http.response.HttpResponse fetchIndex(String bucket, String indexName, long[] values) {
        HttpGet get = new HttpGet(ClientUtils.makeURI(this.config, bucket, indexName, values));
        return this.executeMethod(bucket, null, (HttpRequestBase)get, null);
    }

    public com.basho.riak.client.http.response.HttpResponse ping() {
        HttpGet get = new HttpGet(this.config.getPingUrl());
        return this.executeMethod(null, null, (HttpRequestBase)get, null);
    }

    public RiakExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public com.basho.riak.client.http.response.HttpResponse stats() {
        HttpGet get = new HttpGet(this.config.getStatsUrl());
        return this.executeMethod(null, null, (HttpRequestBase)get, null);
    }

    public void setExceptionHandler(RiakExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public com.basho.riak.client.http.response.HttpResponse toss(RiakIORuntimeException e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
            return new DefaultHttpResponse(null, null, 0, null, null, null, null, null);
        }
        throw e;
    }

    public com.basho.riak.client.http.response.HttpResponse toss(RiakResponseRuntimeException e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(e);
            return new DefaultHttpResponse(null, null, 0, null, null, null, null, null);
        }
        throw e;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public RiakConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    com.basho.riak.client.http.response.HttpResponse executeMethod(String bucket, String key, HttpRequestBase httpMethod, RequestMeta meta, boolean streamResponse) {
        DefaultHttpResponse defaultHttpResponse;
        if (meta != null) {
            Map<String, String> headers = meta.getHeaders();
            for (String header : headers.keySet()) {
                httpMethod.addHeader(header, headers.get(header));
            }
            Map<String, String> queryParams = meta.getQueryParamMap();
            if (!queryParams.isEmpty()) {
                URI newURI;
                URI originalURI = httpMethod.getURI();
                List currentQuery = URLEncodedUtils.parse((URI)originalURI, (String)CharsetUtils.UTF_8.name());
                LinkedList<BasicNameValuePair> newQuery = new LinkedList<BasicNameValuePair>(currentQuery);
                for (Map.Entry<String, String> qp : queryParams.entrySet()) {
                    newQuery.add(new BasicNameValuePair(qp.getKey(), qp.getValue()));
                }
                try {
                    newURI = new URIBuilder(originalURI).setQuery(URLEncodedUtils.format(newQuery, (String)"UTF-8")).build();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    throw new RiakIORuntimeException(e);
                }
                httpMethod.setURI(newURI);
            }
        }
        HttpEntity entity = null;
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)httpMethod);
            int status = 0;
            if (response.getStatusLine() != null) {
                status = response.getStatusLine().getStatusCode();
            }
            Map<String, String> headers = ClientUtils.asHeaderMap(response.getAllHeaders());
            byte[] body = null;
            InputStream stream = null;
            entity = response.getEntity();
            if (streamResponse) {
                stream = entity.getContent();
            } else if (null != entity) {
                body = EntityUtils.toByteArray((HttpEntity)entity);
            }
            key = this.extractKeyFromResponseIfItWasNotAlreadyProvided(key, response);
            defaultHttpResponse = new DefaultHttpResponse(bucket, key, status, headers, body, stream, response, httpMethod);
            if (streamResponse) return defaultHttpResponse;
            if (entity == null) return defaultHttpResponse;
        }
        catch (IOException e) {
            httpMethod.abort();
            com.basho.riak.client.http.response.HttpResponse httpResponse = this.toss(new RiakIORuntimeException(e));
            return httpResponse;
        }
        try {
            EntityUtils.consume((HttpEntity)entity);
            return defaultHttpResponse;
        }
        catch (IOException e) {
            // empty catch block
        }
        return defaultHttpResponse;
        finally {
            if (!streamResponse && entity != null) {
                try {
                    EntityUtils.consume(entity);
                }
                catch (IOException e) {}
            }
        }
    }

    private String extractKeyFromResponseIfItWasNotAlreadyProvided(String key, HttpResponse response) {
        String location;
        Header locationHeader;
        if (key == null && (locationHeader = response.getFirstHeader("Location")) != null && (location = locationHeader.getValue()) != null) {
            int indexOfLastSlash = location.lastIndexOf("/");
            key = location.substring(indexOfLastSlash + 1);
        }
        return key;
    }

    com.basho.riak.client.http.response.HttpResponse executeMethod(String bucket, String key, HttpRequestBase httpMethod, RequestMeta meta) {
        return this.executeMethod(bucket, key, httpMethod, meta, false);
    }

    private HttpRequestBase createStoreHttpMethod(String key, String url) {
        Object storeMethod = null;
        storeMethod = key == null ? new HttpPost(url) : new HttpPut(url);
        return storeMethod;
    }
}

