/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.http.util;

import com.basho.riak.client.http.util.ClientUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkHeader {
    private static String TOKEN = "(?:[^\\(\\)<>@,;:\\\\\"/\\[\\]\\?={} \\t]+?)";
    private static String QUOTED_STRING = "(?:\"(?:\\\\\"|[^\"])*\")";
    private static String PARAMETER = String.format("(?:%s(?:=(?:%s|%s))?)", TOKEN, TOKEN, QUOTED_STRING);
    private static String LINK = "<[^>]*>\\s*(?:;\\s*" + PARAMETER + "?\\s*)*";
    private static String COMMA = "(?:\\s*(?:,\\s*)+)";
    private static String SEMICOLON = "(?:\\s*(?:;\\s*)+)";
    private static String LINK_SPLIT = LINK + "(?=" + COMMA + "|\\s*$)";
    private static String PARAM_SPLIT = PARAMETER + "(?=" + SEMICOLON + "|\\s*$)";
    private static Pattern LINK_SPLITTER = Pattern.compile(LINK_SPLIT);
    private static Pattern PARAM_SPLITTER = Pattern.compile(PARAM_SPLIT);

    public static Map<String, List<Map<String, String>>> parse(String header) {
        LinkedHashMap<String, List<Map<String, String>>> out = new LinkedHashMap<String, List<Map<String, String>>>();
        if (header == null || header.length() == 0) {
            return out;
        }
        Matcher m = LINK_SPLITTER.matcher(header);
        while (m.find()) {
            LinkedList existing;
            String link = m.group().trim();
            String[] urlandparams = link.split(">", 2);
            String url = urlandparams[0].substring(1);
            HashMap<String, String> parsedLink = new HashMap<String, String>();
            if (urlandparams.length > 1) {
                String params = urlandparams[1];
                for (String param : LinkHeader.splitParams(params)) {
                    String[] parts = param.split("=", 2);
                    if (parts.length > 1) {
                        parsedLink.put(parts[0].toLowerCase(), ClientUtils.unquoteString(parts[1]));
                        continue;
                    }
                    parsedLink.put(parts[0].toLowerCase(), null);
                }
            }
            if ((existing = (LinkedList)out.get(url)) == null) {
                existing = new LinkedList();
                out.put(url, existing);
            }
            existing.add(parsedLink);
        }
        return out;
    }

    private static List<String> splitParams(String s) {
        ArrayList<String> items = new ArrayList<String>();
        if (s == null || s.length() == 0) {
            return items;
        }
        Matcher m = PARAM_SPLITTER.matcher(s);
        while (m.find()) {
            items.add(m.group().trim());
        }
        return items;
    }
}

