/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.operations;

import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakRetryFailedException;
import com.basho.riak.client.cap.ConflictResolver;
import com.basho.riak.client.cap.Quora;
import com.basho.riak.client.cap.Quorum;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.cap.UnresolvedConflictException;
import com.basho.riak.client.cap.VClock;
import com.basho.riak.client.convert.ConversionException;
import com.basho.riak.client.convert.Converter;
import com.basho.riak.client.operations.RiakOperation;
import com.basho.riak.client.raw.FetchMeta;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.RiakResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchObject<T>
implements RiakOperation<T> {
    private final String bucket;
    private final RawClient client;
    private final String key;
    private RiakResponse rawResponse;
    private Retrier retrier;
    private FetchMeta.Builder builder;
    private ConflictResolver<T> resolver;
    private Converter<T> converter;

    public FetchObject(RawClient client, String bucket, String key, Retrier retrier) {
        this.bucket = bucket;
        this.client = client;
        this.key = key;
        this.retrier = retrier;
        this.builder = new FetchMeta.Builder();
    }

    public FetchObject(RawClient client, String bucket, String key, Retrier retrier, FetchMeta fetchMeta) {
        this.bucket = bucket;
        this.client = client;
        this.key = key;
        this.retrier = retrier;
        this.builder = FetchMeta.Builder.from(fetchMeta);
    }

    @Override
    public T execute() throws UnresolvedConflictException, RiakRetryFailedException, ConversionException {
        final FetchMeta fetchMeta = this.builder.build();
        Callable<RiakResponse> command = new Callable<RiakResponse>(){

            @Override
            public RiakResponse call() throws Exception {
                return FetchObject.this.client.fetch(FetchObject.this.bucket, FetchObject.this.key, fetchMeta);
            }
        };
        this.rawResponse = this.retrier.attempt(command);
        ArrayList<T> siblings = new ArrayList<T>(this.rawResponse.numberOfValues());
        for (IRiakObject o : this.rawResponse) {
            if (o.isDeleted() && (fetchMeta.getReturnDeletedVClock() == null || !fetchMeta.getReturnDeletedVClock().booleanValue())) continue;
            siblings.add(this.converter.toDomain(o));
        }
        return this.resolver.resolve(siblings);
    }

    public FetchObject<T> withResolver(ConflictResolver<T> resolver) {
        this.resolver = resolver;
        return this;
    }

    public FetchObject<T> r(int r) {
        this.builder.r(r);
        return this;
    }

    public FetchObject<T> r(Quora r) {
        this.builder.r(r);
        return this;
    }

    public FetchObject<T> r(Quorum r) {
        this.builder.r(r);
        return this;
    }

    public FetchObject<T> pr(int pr) {
        this.builder.pr(pr);
        return this;
    }

    public FetchObject<T> pr(Quora pr) {
        this.builder.pr(pr);
        return this;
    }

    public FetchObject<T> pr(Quorum pr) {
        this.builder.pr(pr);
        return this;
    }

    public FetchObject<T> notFoundOK(boolean notFoundOK) {
        this.builder.notFoundOK(notFoundOK);
        return this;
    }

    public FetchObject<T> basicQuorum(boolean basicQuorum) {
        this.builder.basicQuorum(basicQuorum);
        return this;
    }

    public FetchObject<T> returnDeletedVClock(boolean returnDeletedVClock) {
        this.builder.returnDeletedVClock(returnDeletedVClock);
        return this;
    }

    public FetchObject<T> modifiedSince(Date modifiedSince) {
        this.builder.modifiedSince(modifiedSince);
        return this;
    }

    public FetchObject<T> ifModified(VClock vclock) {
        this.builder.vclock(vclock);
        return this;
    }

    public FetchObject<T> headOnly() {
        this.builder.headOnly(true);
        return this;
    }

    public FetchObject<T> withConverter(Converter<T> converter) {
        this.converter = converter;
        return this;
    }

    public FetchObject<T> withRetrier(Retrier retrier) {
        this.retrier = retrier;
        return this;
    }

    public boolean isUnmodified() {
        this.validatePostExecute();
        return this.rawResponse.isUnmodified();
    }

    @Deprecated
    public boolean hasDeletedVclock() {
        this.validatePostExecute();
        return this.rawResponse.isDeleted();
    }

    public boolean hasVclock() {
        this.validatePostExecute();
        return this.rawResponse.getVclock() != null;
    }

    public VClock getVClock() {
        this.validatePostExecute();
        return this.rawResponse.getVclock();
    }

    private void validatePostExecute() {
        if (this.rawResponse == null) {
            throw new IllegalStateException("Please execute the operation before accessing the results");
        }
    }
}

