/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.operations;

import com.basho.riak.client.cap.ConflictResolver;
import com.basho.riak.client.cap.Quora;
import com.basho.riak.client.cap.Quorum;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.convert.Converter;
import com.basho.riak.client.operations.FetchObject;
import com.basho.riak.client.operations.RiakOperation;
import com.basho.riak.client.query.MultiFetchFuture;
import com.basho.riak.client.raw.FetchMeta;
import com.basho.riak.client.raw.RawClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFetchObject<T>
implements RiakOperation<List<MultiFetchFuture<T>>> {
    public static final int DEFAULT_POOL_MAX_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    private static final LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue();
    private static final ThreadPoolExecutor threadPool = new ThreadPoolExecutor(DEFAULT_POOL_MAX_SIZE, DEFAULT_POOL_MAX_SIZE, 5L, TimeUnit.SECONDS, workQueue);
    private final String bucket;
    private final RawClient client;
    private final List<String> keys;
    private FetchMeta.Builder builder = new FetchMeta.Builder();
    private ConflictResolver<T> resolver;
    private Converter<T> converter;
    private Retrier retrier;

    public MultiFetchObject(RawClient client, String bucket, List<String> keys, Retrier retrier) {
        this.bucket = bucket;
        this.client = client;
        this.keys = keys;
        this.retrier = retrier;
    }

    @Override
    public List<MultiFetchFuture<T>> execute() {
        ArrayList<MultiFetchFuture<T>> futureList = new ArrayList<MultiFetchFuture<T>>(this.keys.size());
        FetchMeta fetchMeta = this.builder.build();
        for (String key : this.keys) {
            FetchObject fetchObject = new FetchObject<T>(this.client, this.bucket, key, this.retrier, fetchMeta).withConverter(this.converter).withResolver(this.resolver);
            MultiFetchCallable callable = new MultiFetchCallable(fetchObject);
            MultiFetchFuture task = new MultiFetchFuture(key, callable);
            futureList.add(task);
            threadPool.execute(task);
        }
        return futureList;
    }

    public static void setCorePoolSize(int size) {
        threadPool.setCorePoolSize(size);
        threadPool.setMaximumPoolSize(size);
    }

    public static int getCorePoolSize() {
        return threadPool.getCorePoolSize();
    }

    public MultiFetchObject<T> withResolver(ConflictResolver<T> resolver) {
        this.resolver = resolver;
        return this;
    }

    public MultiFetchObject<T> r(int r) {
        this.builder.r(r);
        return this;
    }

    public MultiFetchObject<T> r(Quora r) {
        this.builder.r(r);
        return this;
    }

    public MultiFetchObject<T> r(Quorum r) {
        this.builder.r(r);
        return this;
    }

    public MultiFetchObject<T> pr(int pr) {
        this.builder.pr(pr);
        return this;
    }

    public MultiFetchObject<T> pr(Quora pr) {
        this.builder.pr(pr);
        return this;
    }

    public MultiFetchObject<T> pr(Quorum pr) {
        this.builder.pr(pr);
        return this;
    }

    public MultiFetchObject<T> notFoundOK(boolean notFoundOK) {
        this.builder.notFoundOK(notFoundOK);
        return this;
    }

    public MultiFetchObject<T> basicQuorum(boolean basicQuorum) {
        this.builder.basicQuorum(basicQuorum);
        return this;
    }

    public MultiFetchObject<T> returnDeletedVClock(boolean returnDeletedVClock) {
        this.builder.returnDeletedVClock(returnDeletedVClock);
        return this;
    }

    public MultiFetchObject<T> modifiedSince(Date modifiedSince) {
        this.builder.modifiedSince(modifiedSince);
        return this;
    }

    public MultiFetchObject<T> headOnly() {
        this.builder.headOnly(true);
        return this;
    }

    public MultiFetchObject<T> withConverter(Converter<T> converter) {
        this.converter = converter;
        return this;
    }

    public MultiFetchObject<T> withRetrier(Retrier retrier) {
        this.retrier = retrier;
        return this;
    }

    static {
        threadPool.allowCoreThreadTimeOut(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiFetchCallable<T>
    implements Callable<T> {
        private FetchObject<T> fetchObject;

        public MultiFetchCallable(FetchObject<T> fetchObject) {
            this.fetchObject = fetchObject;
        }

        @Override
        public T call() throws Exception {
            return this.fetchObject.execute();
        }
    }
}

