/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.query;

import com.basho.riak.client.query.MapReduce;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.query.indexes.IndexQuery;
import com.basho.riak.client.raw.query.indexes.IndexWriter;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;

public class IndexMapReduce
extends MapReduce {
    private static final String BUCKET = "bucket";
    private static final String INDEX = "index";
    private static final String KEY = "key";
    private static final String START = "start";
    private static final String END = "end";
    private final IndexQuery indexQuery;

    public IndexMapReduce(RawClient client, IndexQuery indexQuery) {
        super(client);
        this.indexQuery = indexQuery;
    }

    protected void writeInput(final JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        IndexWriter e = new IndexWriter(){

            private void writeCommon(String bucket, String index) throws IOException {
                jsonGenerator.writeStringField(IndexMapReduce.BUCKET, bucket);
                jsonGenerator.writeStringField(IndexMapReduce.INDEX, index);
            }

            public void write(String bucket, String index, long from, long to) throws IOException {
                this.writeCommon(bucket, index);
                jsonGenerator.writeNumberField(IndexMapReduce.START, from);
                jsonGenerator.writeNumberField(IndexMapReduce.END, to);
            }

            public void write(String bucket, String index, long value) throws IOException {
                this.writeCommon(bucket, index);
                jsonGenerator.writeNumberField(IndexMapReduce.KEY, value);
            }

            public void write(String bucket, String index, String from, String to) throws IOException {
                this.writeCommon(bucket, index);
                jsonGenerator.writeStringField(IndexMapReduce.START, from);
                jsonGenerator.writeStringField(IndexMapReduce.END, to);
            }

            public void write(String bucket, String index, String value) throws IOException {
                this.writeCommon(bucket, index);
                jsonGenerator.writeStringField(IndexMapReduce.KEY, value);
            }
        };
        this.indexQuery.write(e);
        jsonGenerator.writeEndObject();
    }
}

