/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.query.indexes;

import com.basho.riak.client.query.indexes.BinIndex;
import com.basho.riak.client.query.indexes.IntIndex;
import com.basho.riak.client.query.indexes.RiakIndex;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakIndexes {
    private final ConcurrentMap<BinIndex, Set<String>> binIndexes = new ConcurrentHashMap<BinIndex, Set<String>>();
    private final ConcurrentMap<IntIndex, Set<Long>> intIndexes = new ConcurrentHashMap<IntIndex, Set<Long>>();

    public RiakIndexes(Map<BinIndex, Set<String>> binIndexes, Map<IntIndex, Set<Long>> intIndexes) {
        Set<Object> v;
        for (Map.Entry<BinIndex, Set<String>> entry : binIndexes.entrySet()) {
            v = entry.getValue();
            if (v == null) continue;
            this.binIndexes.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        for (Map.Entry<RiakIndex, Set<Object>> entry : intIndexes.entrySet()) {
            v = entry.getValue();
            if (v == null) continue;
            this.intIndexes.put((IntIndex)entry.getKey(), new HashSet(entry.getValue()));
        }
    }

    public RiakIndexes() {
    }

    public Map<BinIndex, Set<String>> getBinIndexes() {
        return new HashMap<BinIndex, Set<String>>(this.binIndexes);
    }

    public Map<IntIndex, Set<Long>> getIntIndexes() {
        return new HashMap<IntIndex, Set<Long>>(this.intIndexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakIndexes add(String index, String value) {
        Set<String> values;
        HashSet newSet;
        BinIndex key = BinIndex.named(index);
        Set prevSet = this.binIndexes.putIfAbsent(key, newSet = new HashSet());
        Set<String> set = values = prevSet == null ? newSet : prevSet;
        synchronized (set) {
            values.add(value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakIndexes addBinSet(String index, Set<String> newValues) {
        Set<String> values;
        HashSet newSet;
        BinIndex key = BinIndex.named(index);
        Set prevSet = this.binIndexes.putIfAbsent(key, newSet = new HashSet());
        Set<String> set = values = prevSet == null ? newSet : prevSet;
        synchronized (set) {
            values.addAll(newValues);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakIndexes add(String index, long value) {
        Set<Long> values;
        HashSet newSet;
        IntIndex key = IntIndex.named(index);
        Set prevSet = this.intIndexes.putIfAbsent(key, newSet = new HashSet());
        Set<Long> set = values = prevSet == null ? newSet : prevSet;
        synchronized (set) {
            values.add(value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiakIndexes addIntSet(String index, Set<? extends Number> newValues) {
        Set<Long> values;
        HashSet newSet;
        IntIndex key = IntIndex.named(index);
        Set prevSet = this.intIndexes.putIfAbsent(key, newSet = new HashSet());
        Set<Long> set = values = prevSet == null ? newSet : prevSet;
        synchronized (set) {
            for (Number number : newValues) {
                values.add(number.longValue());
            }
        }
        return this;
    }

    public RiakIndexes removeAll(BinIndex index) {
        this.binIndexes.remove(index);
        return this;
    }

    public RiakIndexes removeAll(IntIndex index) {
        this.intIndexes.remove(index);
        return this;
    }

    public static RiakIndexes from(RiakIndexes indexes) {
        return new RiakIndexes(indexes.getBinIndexes(), indexes.getIntIndexes());
    }

    public Set<String> getBinIndex(String name) {
        Set values = (Set)this.binIndexes.get(BinIndex.named(name));
        if (values == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(values);
    }

    public Set<Long> getIntIndex(String name) {
        Set values = (Set)this.intIndexes.get(IntIndex.named(name));
        if (values == null) {
            return new HashSet<Long>();
        }
        return new HashSet<Long>(values);
    }
}

