/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw;

import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.cap.BasicVClock;
import com.basho.riak.client.cap.VClock;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakResponse
implements Iterable<IRiakObject> {
    private static final IRiakObject[] NO_OBJECTS = new IRiakObject[0];
    private final VClock vclock;
    private final IRiakObject[] riakObjects;
    private final boolean unmodified;
    private final boolean deleted;

    public RiakResponse(byte[] vclock, IRiakObject[] riakObjects) {
        this.vclock = vclock == null ? null : new BasicVClock(vclock);
        this.riakObjects = riakObjects == null ? NO_OBJECTS : riakObjects;
        this.unmodified = false;
        this.deleted = false;
    }

    @Deprecated
    public RiakResponse(byte[] vclock) {
        if (vclock == null) {
            throw new IllegalArgumentException("vclock cannot be null");
        }
        this.vclock = new BasicVClock(vclock);
        this.riakObjects = NO_OBJECTS;
        this.unmodified = false;
        this.deleted = true;
    }

    private RiakResponse() {
        this.riakObjects = NO_OBJECTS;
        this.vclock = null;
        this.unmodified = false;
        this.deleted = false;
    }

    private RiakResponse(boolean unmodified) {
        this.riakObjects = NO_OBJECTS;
        this.vclock = null;
        this.unmodified = unmodified;
        this.deleted = false;
    }

    public byte[] getVclockBytes() {
        return this.vclock.getBytes();
    }

    public VClock getVclock() {
        return this.vclock;
    }

    public IRiakObject[] getRiakObjects() {
        return this.riakObjects;
    }

    public boolean hasSiblings() {
        return this.riakObjects.length > 1;
    }

    public boolean hasValue() {
        return this.riakObjects.length > 0;
    }

    public int numberOfValues() {
        return this.riakObjects.length;
    }

    public boolean isUnmodified() {
        return this.unmodified;
    }

    @Deprecated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public Iterator<IRiakObject> iterator() {
        return Arrays.asList(this.riakObjects).iterator();
    }

    public static RiakResponse empty() {
        return new RiakResponse();
    }

    public static RiakResponse empty(boolean unmodified) {
        return new RiakResponse(unmodified);
    }

    public static RiakResponse unmodified() {
        return new RiakResponse(true);
    }

    public static RiakResponse matchFound() {
        return null;
    }
}

