/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.http;

import com.basho.riak.client.http.response.BucketResponse;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeySource
implements Iterator<String> {
    private static final Timer timer = new Timer("riak-client-key-stream-timeout-thread", true);
    private final BucketResponse bucketResponse;
    private final Iterator<String> keys;
    private ReaperTask reaper;

    public KeySource(BucketResponse bucketResponse) {
        this.bucketResponse = bucketResponse;
        this.keys = bucketResponse.getBucketInfo().getKeys().iterator();
        this.reaper = new ReaperTask(this, bucketResponse);
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.keys.hasNext();
        if (!hasNext) {
            this.reaper.cancel();
            this.bucketResponse.close();
        }
        return hasNext;
    }

    @Override
    public String next() {
        return this.keys.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static class ReaperTask
    extends TimerTask {
        private final BucketResponse bucketResponse;
        private WeakReference<?> ref;

        ReaperTask(Object holder, BucketResponse conn) {
            this.bucketResponse = conn;
            this.ref = new WeakReference<Object>(holder);
            timer.scheduleAtFixedRate((TimerTask)this, 500L, 500L);
        }

        public synchronized void run() {
            if (this.ref != null && this.ref.get() == null) {
                this.cancel();
                this.bucketResponse.close();
            }
        }

        public synchronized boolean cancel() {
            this.ref = null;
            return super.cancel();
        }
    }
}

