/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.raw.pbc;

import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.RiakClientFactory;
import com.basho.riak.client.raw.config.Configuration;
import com.basho.riak.client.raw.pbc.PBClientAdapter;
import com.basho.riak.client.raw.pbc.PBClientConfig;
import com.basho.riak.pbc.RiakClient;
import com.basho.riak.pbc.RiakConnectionPool;
import java.io.IOException;
import java.net.InetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBRiakClientFactory
implements RiakClientFactory {
    private static final PBRiakClientFactory instance = new PBRiakClientFactory();

    private PBRiakClientFactory() {
    }

    public static PBRiakClientFactory getInstance() {
        return instance;
    }

    @Override
    public boolean accepts(Class<? extends Configuration> configClass) {
        return configClass.equals(PBClientConfig.class);
    }

    @Override
    public RawClient newClient(Configuration config) throws IOException {
        PBClientConfig conf = (PBClientConfig)config;
        InetAddress hostAddress = InetAddress.getByName(conf.getHost());
        RiakConnectionPool pool = new RiakConnectionPool(conf.getInitialPoolSize(), conf.getPoolSize(), hostAddress, conf.getPort(), conf.getConnectionWaitTimeoutMillis(), conf.getSocketBufferSizeKb(), conf.getIdleConnectionTTLMillis(), conf.getRequestTimeoutMillis());
        pool.start();
        return new PBClientAdapter(new RiakClient(pool));
    }
}

