/*
 * This file is provided to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.basho.riak.client.query;

import java.util.Collection;

import com.basho.riak.client.IRiakObject;

/**
 * Interface defining results from a walk operation, basically an iteration of
 * steps, each step contains some {@link IRiakObject}s.
 * 
 * <p>
 * Expect this to be added to in the near future with siblings and conversion
 * <p/>
 * 
 * @author russell
 * 
 */
public interface WalkResult extends Iterable<Collection<IRiakObject>> {
}
