/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.chainr;

import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.chainr.instantiator.ChainrInstantiator;
import com.bazaarvoice.jolt.chainr.instantiator.DefaultChainrInstantiator;
import com.bazaarvoice.jolt.chainr.spec.ChainrEntry;
import com.bazaarvoice.jolt.chainr.spec.ChainrSpec;
import java.util.ArrayList;

public class ChainrBuilder {
    private final ChainrSpec chainrSpec;
    protected ChainrInstantiator chainrInstantiator = new DefaultChainrInstantiator();

    public ChainrBuilder(Object chainrSpecObj) {
        this.chainrSpec = new ChainrSpec(chainrSpecObj);
    }

    public ChainrBuilder loader(ChainrInstantiator loader) {
        if (loader == null) {
            throw new IllegalArgumentException("ChainrBuilder requires a non-null loader.");
        }
        this.chainrInstantiator = loader;
        return this;
    }

    public Chainr build() {
        ArrayList<JoltTransform> transforms = new ArrayList<JoltTransform>(this.chainrSpec.getChainrEntries().size());
        for (ChainrEntry entry : this.chainrSpec.getChainrEntries()) {
            JoltTransform transform = this.chainrInstantiator.hydrateTransform(entry);
            transforms.add(transform);
        }
        return new Chainr(transforms);
    }
}

