/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.chainr.spec;

import com.bazaarvoice.jolt.CardinalityTransform;
import com.bazaarvoice.jolt.Chainr;
import com.bazaarvoice.jolt.Defaultr;
import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.Removr;
import com.bazaarvoice.jolt.Shiftr;
import com.bazaarvoice.jolt.Sortr;
import com.bazaarvoice.jolt.SpecDriven;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.utils.StringTools;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ChainrEntry {
    public static final Map<String, String> STOCK_TRANSFORMS;
    public static final String OPERATION_KEY = "operation";
    public static final String SPEC_KEY = "spec";
    private final int index;
    private final Object spec;
    private final String operationClassName;
    private final Class<? extends JoltTransform> joltTransformClass;
    private final boolean isSpecDriven;

    public ChainrEntry(int index, Object chainrEntryObj) {
        if (!(chainrEntryObj instanceof Map)) {
            throw new SpecException("JOLT ChainrEntry expects a JSON map - Malformed spec" + this.getErrorMessageIndexSuffix());
        }
        Map chainrEntryMap = (Map)chainrEntryObj;
        this.index = index;
        String opString = this.extractOperationString(OPERATION_KEY, chainrEntryMap);
        if (opString == null) {
            throw new SpecException("JOLT Chainr 'operation' must implement Transform or ContextualTransform" + this.getErrorMessageIndexSuffix());
        }
        this.operationClassName = STOCK_TRANSFORMS.containsKey(opString) ? STOCK_TRANSFORMS.get(opString) : opString;
        this.joltTransformClass = this.loadJoltTransformClass();
        this.spec = chainrEntryMap.get(SPEC_KEY);
        this.isSpecDriven = SpecDriven.class.isAssignableFrom(this.joltTransformClass);
        if (this.isSpecDriven && !chainrEntryMap.containsKey(SPEC_KEY)) {
            throw new SpecException("JOLT Chainr - Transform className:" + this.joltTransformClass.getCanonicalName() + " requires a spec" + this.getErrorMessageIndexSuffix());
        }
    }

    private String extractOperationString(String key, Map<String, Object> chainrEntryMap) {
        Object operationNameObj = chainrEntryMap.get(key);
        if (operationNameObj == null) {
            return null;
        }
        if (operationNameObj instanceof String) {
            if (StringTools.isBlank((String)operationNameObj)) {
                throw new SpecException("JOLT Chainr 'operation' should not be blank" + this.getErrorMessageIndexSuffix());
            }
            return (String)operationNameObj;
        }
        throw new SpecException("JOLT Chainr needs a 'operation' of type String" + this.getErrorMessageIndexSuffix());
    }

    private Class<? extends JoltTransform> loadJoltTransformClass() {
        try {
            Class<?> opClass = Class.forName(this.operationClassName);
            if (Chainr.class.isAssignableFrom(opClass)) {
                throw new SpecException("Attempt to nest Chainr inside itself" + this.getErrorMessageIndexSuffix());
            }
            if (!JoltTransform.class.isAssignableFrom(opClass)) {
                throw new SpecException("JOLT Chainr class:" + this.operationClassName + " does not implement the JoltTransform interface" + this.getErrorMessageIndexSuffix());
            }
            Class<?> transformClass = opClass;
            return transformClass;
        }
        catch (ClassNotFoundException e) {
            throw new SpecException("JOLT Chainr could not find transform class:" + this.operationClassName + this.getErrorMessageIndexSuffix(), e);
        }
    }

    public String getErrorMessageIndexSuffix() {
        return " at index:" + this.index + ".";
    }

    public Object getSpec() {
        return this.spec;
    }

    public Class<? extends JoltTransform> getJoltTransformClass() {
        return this.joltTransformClass;
    }

    public boolean isSpecDriven() {
        return this.isSpecDriven;
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("shift", Shiftr.class.getCanonicalName());
        temp.put("default", Defaultr.class.getCanonicalName());
        temp.put("remove", Removr.class.getCanonicalName());
        temp.put("sort", Sortr.class.getCanonicalName());
        temp.put("cardinality", CardinalityTransform.class.getCanonicalName());
        STOCK_TRANSFORMS = Collections.unmodifiableMap(temp);
    }
}

