/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common.pathelement;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.BasePathElement;
import com.bazaarvoice.jolt.common.pathelement.EvaluatablePathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.common.reference.AmpReference;
import com.bazaarvoice.jolt.common.reference.HashReference;
import com.bazaarvoice.jolt.common.reference.PathAndGroupReference;
import com.bazaarvoice.jolt.common.reference.PathReference;
import com.bazaarvoice.jolt.exception.SpecException;

public class ArrayPathElement
extends BasePathElement
implements MatchablePathElement,
EvaluatablePathElement {
    private final ArrayPathType arrayPathType;
    private final PathReference ref;
    private final String canonicalForm;
    private final String arrayIndex;

    public ArrayPathElement(String key) {
        super(key);
        ArrayPathType apt;
        if (key.charAt(0) != '[' || key.charAt(key.length() - 1) != ']') {
            throw new SpecException("Invalid ArrayPathElement key:" + key);
        }
        PathReference r = null;
        String aI = "";
        if (key.length() == 2) {
            apt = ArrayPathType.AUTO_EXPAND;
            this.canonicalForm = "[]";
        } else {
            String meat = key.substring(1, key.length() - 1);
            if (AmpReference.TOKEN.equals(Character.valueOf(meat.charAt(0)))) {
                r = new AmpReference(meat);
                apt = ArrayPathType.REFERENCE;
                this.canonicalForm = "[" + r.getCanonicalForm() + "]";
            } else if (HashReference.TOKEN.equals(Character.valueOf(meat.charAt(0)))) {
                r = new HashReference(meat);
                apt = ArrayPathType.HASH;
                this.canonicalForm = "[" + r.getCanonicalForm() + "]";
            } else {
                try {
                    Integer.parseInt(meat);
                    apt = ArrayPathType.EXPLICIT_INDEX;
                    this.canonicalForm = "[" + meat + "]";
                    aI = meat;
                }
                catch (NumberFormatException nfe) {
                    throw new SpecException("Unable to parse explicit array index of:" + meat + " from key:" + key);
                }
            }
        }
        this.arrayPathType = apt;
        this.ref = r;
        this.arrayIndex = aI;
    }

    @Override
    public String getCanonicalForm() {
        return this.canonicalForm;
    }

    @Override
    public String evaluate(WalkedPath walkedPath) {
        switch (this.arrayPathType) {
            case AUTO_EXPAND: {
                return this.canonicalForm;
            }
            case EXPLICIT_INDEX: {
                return this.arrayIndex;
            }
            case HASH: {
                LiteralPathElement element = walkedPath.elementFromEnd(this.ref.getPathIndex());
                Integer index = element.getHashCount();
                return index.toString();
            }
            case REFERENCE: {
                LiteralPathElement lpe = walkedPath.elementFromEnd(this.ref.getPathIndex());
                String keyPart = this.ref instanceof PathAndGroupReference ? lpe.getSubKeyRef(((PathAndGroupReference)this.ref).getKeyGroup()) : lpe.getSubKeyRef(0);
                try {
                    Integer.parseInt(keyPart);
                    return keyPart;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException(" Evaluating canonical ReferencePathElement:" + this.getCanonicalForm() + ", and got a non integer result for reference:" + this.ref.getCanonicalForm());
                }
            }
        }
        throw new IllegalStateException("ArrayPathType enum added two without updating this switch statement.");
    }

    @Override
    public LiteralPathElement match(String dataKey, WalkedPath walkedPath) {
        String evaled = this.evaluate(walkedPath);
        if (evaled.equals(dataKey)) {
            return new LiteralPathElement(evaled);
        }
        return null;
    }

    public static enum ArrayPathType {
        AUTO_EXPAND,
        REFERENCE,
        HASH,
        EXPLICIT_INDEX;

    }
}

