/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common.pathelement;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.BasePathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarPathElement;
import com.bazaarvoice.jolt.utils.StringTools;
import java.util.ArrayList;

public class StarDoublePathElement
extends BasePathElement
implements StarPathElement {
    private final String prefix;
    private final String suffix;
    private final String mid;

    public StarDoublePathElement(String key) {
        super(key);
        if (StringTools.countMatches(key, "*") != 2) {
            throw new IllegalArgumentException("StarDoublePathElement should have two '*' in its key.");
        }
        String[] split = key.split("\\*");
        boolean startsWithStar = key.startsWith("*");
        boolean endsWithStar = key.endsWith("*");
        if (startsWithStar && endsWithStar) {
            this.prefix = "";
            this.mid = split[1];
            this.suffix = "";
        } else if (endsWithStar) {
            this.prefix = split[0];
            this.mid = split[1];
            this.suffix = "";
        } else if (startsWithStar) {
            this.prefix = "";
            this.mid = split[1];
            this.suffix = split[2];
        } else {
            this.prefix = split[0];
            this.mid = split[1];
            this.suffix = split[2];
        }
    }

    @Override
    public boolean stringMatch(String literal) {
        boolean isMatch = false;
        if (literal.startsWith(this.prefix) && literal.endsWith(this.suffix)) {
            isMatch = this.finMidIndex(literal) > 0;
        }
        return isMatch;
    }

    private int finMidIndex(String literal) {
        int endOffset;
        int startOffset = this.prefix.length() + 1;
        if (startOffset >= (endOffset = literal.length() - this.suffix.length() - 1)) {
            return -1;
        }
        int midIndex = literal.substring(startOffset, endOffset).indexOf(this.mid);
        if (midIndex >= 0) {
            return midIndex + startOffset;
        }
        return -1;
    }

    @Override
    public LiteralPathElement match(String dataKey, WalkedPath walkedPath) {
        if (this.stringMatch(dataKey)) {
            ArrayList<String> subKeys = new ArrayList<String>(2);
            int midStart = this.finMidIndex(dataKey);
            int midEnd = midStart + this.mid.length();
            String firstStarPart = dataKey.substring(this.prefix.length(), midStart);
            subKeys.add(firstStarPart);
            String secondStarPart = dataKey.substring(midEnd, dataKey.length() - this.suffix.length());
            subKeys.add(secondStarPart);
            return new LiteralPathElement(dataKey, subKeys);
        }
        return null;
    }

    @Override
    public String getCanonicalForm() {
        return this.getRawKey();
    }
}

