/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common.pathelement;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.BasePathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarPathElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StarRegexPathElement
extends BasePathElement
implements StarPathElement {
    private final Pattern pattern;

    public StarRegexPathElement(String key) {
        super(key);
        this.pattern = StarRegexPathElement.makePattern(key);
    }

    private static Pattern makePattern(String key) {
        key = StarRegexPathElement.escapeMetacharsIfAny(key);
        String regex = "^" + key.replace("*", "(.+?)") + "$";
        return Pattern.compile(regex);
    }

    private static String escapeMetacharsIfAny(String key) {
        char[] keyChars = key.toCharArray();
        HashSet<Character> charsAlreadySeen = new HashSet<Character>();
        block3: for (char keychar : keyChars) {
            switch (keychar) {
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': {
                    if (charsAlreadySeen.contains(Character.valueOf(keychar))) continue block3;
                    key = key.replace(String.valueOf(keychar), "\\" + keychar);
                    charsAlreadySeen.add(Character.valueOf(keychar));
                    continue block3;
                }
            }
        }
        return key;
    }

    @Override
    public boolean stringMatch(String literal) {
        Matcher matcher = this.pattern.matcher(literal);
        return matcher.find();
    }

    @Override
    public LiteralPathElement match(String dataKey, WalkedPath walkedPath) {
        Matcher matcher = this.pattern.matcher(dataKey);
        if (!matcher.find()) {
            return null;
        }
        int groupCount = matcher.groupCount();
        ArrayList<String> subKeys = new ArrayList<String>(groupCount);
        for (int index = 1; index <= groupCount; ++index) {
            subKeys.add(matcher.group(index));
        }
        return new LiteralPathElement(dataKey, subKeys);
    }

    @Override
    public String getCanonicalForm() {
        return this.getRawKey();
    }
}

