/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common.pathelement;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.BasePathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarPathElement;
import com.bazaarvoice.jolt.utils.StringTools;
import java.util.ArrayList;

public class StarSinglePathElement
extends BasePathElement
implements StarPathElement {
    private final String prefix;
    private final String suffix;

    public StarSinglePathElement(String key) {
        super(key);
        if (StringTools.countMatches(key, "*") != 1) {
            throw new IllegalArgumentException("StarSinglePathElement should only have one '*' in its key.");
        }
        if ("*".equals(key)) {
            throw new IllegalArgumentException("StarSinglePathElement should have a key that is just '*'.");
        }
        if (key.startsWith("*")) {
            this.prefix = "";
            this.suffix = key.substring(1);
        } else if (key.endsWith("*")) {
            this.prefix = key.substring(0, key.length() - 1);
            this.suffix = "";
        } else {
            String[] split = key.split("\\*");
            this.prefix = split[0];
            this.suffix = split[1];
        }
    }

    @Override
    public boolean stringMatch(String literal) {
        return literal.startsWith(this.prefix) && literal.endsWith(this.suffix) && literal.length() > this.prefix.length() + this.suffix.length();
    }

    @Override
    public LiteralPathElement match(String dataKey, WalkedPath walkedPath) {
        if (this.stringMatch(dataKey)) {
            ArrayList<String> subKeys = new ArrayList<String>(1);
            String starPart = dataKey.substring(this.prefix.length(), dataKey.length() - this.suffix.length());
            subKeys.add(starPart);
            return new LiteralPathElement(dataKey, subKeys);
        }
        return null;
    }

    @Override
    public String getCanonicalForm() {
        return this.getRawKey();
    }
}

