/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.defaultr;

import com.bazaarvoice.jolt.defaultr.ArrayKey;
import com.bazaarvoice.jolt.defaultr.MapKey;
import com.bazaarvoice.jolt.defaultr.OPS;
import com.bazaarvoice.jolt.exception.TransformException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Key {
    private static final String OR_INPUT_REGEX = "\\|";
    private static final KeyPrecedenceComparator keyComparator = new KeyPrecedenceComparator();
    private boolean isArrayOutput = false;
    private OPS op = null;
    private int orCount = 0;
    private int outputArraySize = -1;
    protected Set<Key> children = null;
    protected Object literalValue = null;
    protected String rawKey;
    protected List<String> keyStrings;

    public static Set<Key> parseSpec(Map<String, Object> spec) {
        return Key.processSpec(false, spec);
    }

    private static Set<Key> processSpec(boolean parentIsArray, Map<String, Object> spec) {
        HashSet<Key> result = new HashSet<Key>();
        for (String key : spec.keySet()) {
            Object subSpec = spec.get(key);
            if (parentIsArray) {
                result.add(new ArrayKey(key, subSpec));
                continue;
            }
            result.add(new MapKey(key, subSpec));
        }
        return result;
    }

    public Key(String rawJsonKey, Object spec) {
        this.rawKey = rawJsonKey;
        if (rawJsonKey.endsWith("[]")) {
            this.isArrayOutput = true;
            this.rawKey = this.rawKey.replace("[]", "");
        }
        this.op = OPS.parse(this.rawKey);
        switch (this.op) {
            case OR: {
                this.keyStrings = Arrays.asList(this.rawKey.split(OR_INPUT_REGEX));
                this.orCount = this.keyStrings.size();
                break;
            }
            case LITERAL: {
                this.keyStrings = Arrays.asList(this.rawKey);
                break;
            }
            case STAR: {
                this.keyStrings = Collections.emptyList();
                break;
            }
            default: {
                throw new IllegalStateException("Someone has added an op type without changing this method.");
            }
        }
        if (spec instanceof Map) {
            this.children = Key.processSpec(this.isArrayOutput(), (Map)spec);
            if (this.isArrayOutput()) {
                for (Key childKey : this.children) {
                    int childValue = childKey.getLiteralIntKey();
                    if (childValue <= this.outputArraySize) continue;
                    this.outputArraySize = childValue;
                }
            }
        } else {
            this.literalValue = spec;
        }
    }

    public void applyChildren(Object defaultee) {
        if (defaultee == null) {
            throw new TransformException("Defaultee should never be null when passed to the applyChildren method.");
        }
        if (this.isArrayOutput() && defaultee instanceof List) {
            List defaultList = (List)defaultee;
            for (int index = defaultList.size() - 1; index < this.getOutputArraySize(); ++index) {
                defaultList.add(null);
            }
        }
        ArrayList<Key> sortedChildren = new ArrayList<Key>();
        sortedChildren.addAll(this.children);
        Collections.sort(sortedChildren, keyComparator);
        for (Key childKey : sortedChildren) {
            childKey.applyChild(defaultee);
        }
    }

    protected abstract int getLiteralIntKey();

    protected abstract void applyChild(Object var1);

    public int getOrCount() {
        return this.orCount;
    }

    public boolean isArrayOutput() {
        return this.isArrayOutput;
    }

    public OPS getOp() {
        return this.op;
    }

    public int getOutputArraySize() {
        return this.outputArraySize;
    }

    public Object createOutputContainerObject() {
        if (this.isArrayOutput()) {
            return new ArrayList();
        }
        return new LinkedHashMap();
    }

    public static class KeyPrecedenceComparator
    implements Comparator<Key> {
        private OPS.OpsPrecedenceComparator opsComparator = new OPS.OpsPrecedenceComparator();

        @Override
        public int compare(Key a, Key b) {
            int opsEqual = this.opsComparator.compare(a.getOp(), b.getOp());
            if (opsEqual == 0 && OPS.OR == a.getOp() && OPS.OR == b.getOp()) {
                return a.getOrCount() < b.getOrCount() ? -1 : (a.getOrCount() == b.getOrCount() ? a.rawKey.compareTo(b.rawKey) : 1);
            }
            return opsEqual;
        }
    }
}

