/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.removr.spec;

import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.removr.spec.RemovrLeafSpec;
import com.bazaarvoice.jolt.removr.spec.RemovrSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RemovrCompositeSpec
extends RemovrSpec {
    private final List<RemovrSpec> allChildren;

    public RemovrCompositeSpec(String rawKey, Map<String, Object> spec) {
        super(rawKey);
        ArrayList<RemovrCompositeSpec> all = new ArrayList<RemovrCompositeSpec>();
        for (String rawLhsStr : spec.keySet()) {
            String[] keyStrings;
            Object rawRhs = spec.get(rawLhsStr);
            for (String keyString : keyStrings = rawLhsStr.split("\\|")) {
                RemovrSpec childSpec;
                if (rawRhs instanceof Map) {
                    childSpec = new RemovrCompositeSpec(keyString, (Map)rawRhs);
                } else if (rawRhs instanceof String && ((String)rawRhs).trim().length() == 0) {
                    childSpec = new RemovrLeafSpec(keyString);
                } else {
                    throw new SpecException("Invalid Removr spec RHS. Should be a non-empty string or Map");
                }
                all.add((RemovrCompositeSpec)childSpec);
            }
        }
        this.allChildren = Collections.unmodifiableList(all);
    }

    @Override
    public void remove(Map<String, Object> input) {
        if (this.pathElement instanceof LiteralPathElement) {
            this.handleLiterals(input);
        } else {
            this.handleComputed(input);
        }
    }

    @Override
    public void removeByKey(Map<String, Object> inputMap, String literalKey) {
        Object subInput = inputMap.get(literalKey);
        if (subInput instanceof Map) {
            for (RemovrSpec childSpec : this.allChildren) {
                childSpec.remove((Map)subInput);
            }
        }
    }

    private void handleLiterals(Map<String, Object> input) {
        if (input == null) {
            return;
        }
        this.removeByKey(input, this.pathElement.getRawKey());
    }

    private void handleComputed(Map<String, Object> input) {
        List<String> keysToBeRemoved = this.findKeysToBeRemoved(input);
        for (String key : keysToBeRemoved) {
            if (!(input.get(key) instanceof Map)) continue;
            this.removeByKey(input, key);
        }
    }
}

