/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.removr.spec;

import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.common.pathelement.PathElement;
import com.bazaarvoice.jolt.common.pathelement.StarAllPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarDoublePathElement;
import com.bazaarvoice.jolt.common.pathelement.StarPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarRegexPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarSinglePathElement;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.utils.StringTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class RemovrSpec {
    protected final MatchablePathElement pathElement;

    public RemovrSpec(String rawJsonKey) {
        List<PathElement> pathElements = RemovrSpec.parse(rawJsonKey);
        if (pathElements.size() != 1) {
            throw new SpecException("Removr invalid LHS:" + rawJsonKey + " can not contain '.'");
        }
        PathElement pe = pathElements.get(0);
        if (!(pe instanceof MatchablePathElement)) {
            throw new SpecException("Spec LHS key=" + rawJsonKey + " is not a valid LHS key.");
        }
        this.pathElement = (MatchablePathElement)pe;
    }

    public static List<PathElement> parse(String key) {
        if ("*".equals(key)) {
            return Arrays.asList(new StarAllPathElement(key));
        }
        int numOfStars = StringTools.countMatches(key, "*");
        if (numOfStars == 1) {
            return Arrays.asList(new StarSinglePathElement(key));
        }
        if (numOfStars == 2) {
            return Arrays.asList(new StarDoublePathElement(key));
        }
        if (numOfStars > 2) {
            return Arrays.asList(new StarRegexPathElement(key));
        }
        return Arrays.asList(new LiteralPathElement(key));
    }

    public List<String> findKeysToBeRemoved(Map<String, Object> input) {
        ArrayList<String> keysToBeRemoved = new ArrayList<String>();
        boolean isStarPathElement = this.pathElement instanceof StarPathElement;
        for (String ipkey : input.keySet()) {
            if (isStarPathElement) {
                if (!((StarPathElement)this.pathElement).stringMatch(ipkey)) continue;
                keysToBeRemoved.add(ipkey);
                continue;
            }
            keysToBeRemoved.add(this.pathElement.getRawKey());
        }
        return keysToBeRemoved;
    }

    public abstract void remove(Map<String, Object> var1);

    public abstract void removeByKey(Map<String, Object> var1, String var2);
}

