/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.shiftr;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.EvaluatablePathElement;
import com.bazaarvoice.jolt.common.pathelement.PathElement;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.shiftr.ShiftrTraversr;
import com.bazaarvoice.jolt.shiftr.spec.ShiftrSpec;
import com.bazaarvoice.jolt.traversr.Traversr;
import com.bazaarvoice.jolt.utils.StringTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ShiftrWriter {
    private final List<EvaluatablePathElement> elements;
    private final Traversr traversr;

    public ShiftrWriter(String dotNotation) {
        ShiftrTraversr trav;
        List<Object> paths;
        if (dotNotation.contains("@") || dotNotation.contains("*") || dotNotation.contains("$")) {
            throw new SpecException("DotNotation (write key) can not contain '@', '*', or '$'.");
        }
        if (StringTools.isNotBlank(dotNotation)) {
            String[] split = dotNotation.split("\\.");
            paths = ShiftrSpec.parse(split);
            trav = new ShiftrTraversr(dotNotation);
        } else {
            paths = Collections.emptyList();
            trav = new ShiftrTraversr("");
        }
        ArrayList<EvaluatablePathElement> evalPaths = new ArrayList<EvaluatablePathElement>(paths.size());
        for (PathElement pathElement : paths) {
            if (!(pathElement instanceof EvaluatablePathElement)) {
                throw new SpecException("RHS key=" + pathElement.getRawKey() + " is not a valid RHS key.");
            }
            evalPaths.add((EvaluatablePathElement)pathElement);
        }
        this.elements = Collections.unmodifiableList(evalPaths);
        this.traversr = trav;
    }

    public void write(Object data, Map<String, Object> output, WalkedPath walkedPath) {
        this.traversr.set(output, this.evaluate(walkedPath), data);
    }

    List<String> evaluate(WalkedPath walkedPath) {
        ArrayList<String> strings = new ArrayList<String>(this.elements.size());
        for (EvaluatablePathElement pathElement : this.elements) {
            String evaledLeafOutput = pathElement.evaluate(walkedPath);
            strings.add(evaledLeafOutput);
        }
        return strings;
    }

    public int size() {
        return this.elements.size();
    }

    public PathElement get(int index) {
        return this.elements.get(index);
    }

    public String getCanonicalForm() {
        StringBuilder buf = new StringBuilder();
        for (EvaluatablePathElement pe : this.elements) {
            buf.append(".").append(pe.getCanonicalForm());
        }
        return buf.substring(1);
    }
}

