/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.shiftr.spec;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.AmpPathElement;
import com.bazaarvoice.jolt.common.pathelement.ArrayPathElement;
import com.bazaarvoice.jolt.common.pathelement.AtPathElement;
import com.bazaarvoice.jolt.common.pathelement.DollarPathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.common.pathelement.PathElement;
import com.bazaarvoice.jolt.common.pathelement.StarAllPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarDoublePathElement;
import com.bazaarvoice.jolt.common.pathelement.StarRegexPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarSinglePathElement;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.utils.StringTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class ShiftrSpec {
    protected final MatchablePathElement pathElement;

    public ShiftrSpec(String rawJsonKey) {
        List<PathElement> pathElements = ShiftrSpec.parse(rawJsonKey);
        if (pathElements.size() != 1) {
            throw new SpecException("Shiftr invalid LHS:" + rawJsonKey + " can not contain '.'");
        }
        PathElement pe = pathElements.get(0);
        if (!(pe instanceof MatchablePathElement)) {
            throw new SpecException("Spec LHS key=" + rawJsonKey + " is not a valid LHS key.");
        }
        this.pathElement = (MatchablePathElement)pe;
    }

    public static List<PathElement> parse(String key) {
        if (key.contains("@")) {
            return Arrays.asList(new AtPathElement(key));
        }
        if (key.contains("$")) {
            return Arrays.asList(new DollarPathElement(key));
        }
        if (key.contains("[")) {
            if (StringTools.countMatches(key, "[") != 1 || StringTools.countMatches(key, "]") != 1) {
                throw new SpecException("Invalid key:" + key + " has too many [] references.");
            }
            if (key.charAt(0) == '[' && key.charAt(key.length() - 1) == ']') {
                return Arrays.asList(new ArrayPathElement(key));
            }
            String canonicalKey = key.replace("[", ".[");
            String[] subkeys = canonicalKey.split("\\.");
            List<PathElement> subElements = ShiftrSpec.parse(subkeys);
            for (int index = 0; index < subElements.size() - 1; ++index) {
                PathElement v = subElements.get(index);
                if (!(v instanceof ArrayPathElement)) continue;
                throw new SpecException("Array [..] must be the last thing in the key, was:" + key);
            }
            return subElements;
        }
        if (key.contains("&")) {
            if (key.contains("*")) {
                throw new SpecException("Can't mix * with & ) ");
            }
            return Arrays.asList(new AmpPathElement(key));
        }
        if ("*".equals(key)) {
            return Arrays.asList(new StarAllPathElement(key));
        }
        if (key.contains("*")) {
            int numOfStars = StringTools.countMatches(key, "*");
            if (numOfStars == 1) {
                return Arrays.asList(new StarSinglePathElement(key));
            }
            if (numOfStars == 2) {
                return Arrays.asList(new StarDoublePathElement(key));
            }
            return Arrays.asList(new StarRegexPathElement(key));
        }
        return Arrays.asList(new LiteralPathElement(key));
    }

    public static List<PathElement> parse(String[] keys) {
        ArrayList<PathElement> paths = new ArrayList<PathElement>();
        for (String key : keys) {
            List<PathElement> subPaths = ShiftrSpec.parse(key);
            for (PathElement path : subPaths) {
                paths.add(path);
            }
        }
        return paths;
    }

    public abstract boolean apply(String var1, Object var2, WalkedPath var3, Map<String, Object> var4);
}

