/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.traversr.traversal;

import com.bazaarvoice.jolt.traversr.Traversr;
import com.bazaarvoice.jolt.traversr.traversal.BaseTraversalStep;
import com.bazaarvoice.jolt.traversr.traversal.TraversalStep;
import java.util.ArrayList;
import java.util.List;

public class ArrayTraversalStep
extends BaseTraversalStep<List<Object>> {
    public ArrayTraversalStep(Traversr traversr, TraversalStep child) {
        super(traversr, child);
    }

    @Override
    public Class getStepType() {
        return List.class;
    }

    @Override
    public Object newContainer() {
        return new ArrayList();
    }

    @Override
    public Object get(List<Object> list, String key) {
        int arrayIndex = Integer.parseInt(key);
        if (arrayIndex < list.size()) {
            return list.get(arrayIndex);
        }
        return null;
    }

    @Override
    public Object remove(List<Object> list, String key) {
        int arrayIndex = Integer.parseInt(key);
        if (arrayIndex < list.size()) {
            return list.remove(arrayIndex);
        }
        return null;
    }

    @Override
    public Object overwriteSet(List<Object> list, String key, Object data) {
        int arrayIndex = Integer.parseInt(key);
        ArrayTraversalStep.ensureArraySize(list, arrayIndex);
        list.set(arrayIndex, data);
        return data;
    }

    public static void ensureArraySize(List<Object> list, Integer upperIndex) {
        for (int sizing = list.size(); sizing <= upperIndex; ++sizing) {
            list.add(null);
        }
    }
}

