/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JoltUtils {
    public static void removeRecursive(Object json, String keyToRemove) {
        if (json == null || keyToRemove == null) {
            return;
        }
        if (json instanceof Map) {
            Map jsonMap = (Map)JoltUtils.cast(json);
            if (jsonMap.containsKey(keyToRemove)) {
                jsonMap.remove(keyToRemove);
            }
            for (String subKey : jsonMap.keySet()) {
                Object value = jsonMap.get(subKey);
                JoltUtils.removeRecursive(value, keyToRemove);
            }
        }
        if (json instanceof List) {
            for (Object value : (List)json) {
                JoltUtils.removeRecursive(value, keyToRemove);
            }
        }
    }

    public static <T> T navigate(Object source, Object ... paths) {
        Object destination = source;
        for (Object path : paths) {
            if (path == null || destination == null) {
                throw new NullPointerException("source or path is null");
            }
            if (destination instanceof Map) {
                destination = ((Map)destination).get(path);
                continue;
            }
            if (path instanceof Integer && destination instanceof List) {
                destination = ((List)destination).get((Integer)path);
                continue;
            }
            throw new UnsupportedOperationException("Navigation supports only Map and List source types and non-null String and Integer path types");
        }
        return JoltUtils.cast(destination);
    }

    public static <T> T navigateSafe(T defaultValue, Object source, Object ... paths) {
        Object destination = source;
        for (Object path : paths) {
            if (path == null || destination == null) {
                return defaultValue;
            }
            if (destination instanceof Map) {
                Map destinationMap = (Map)destination;
                if (!destinationMap.containsKey(path)) {
                    return defaultValue;
                }
                destination = destinationMap.get(path);
                continue;
            }
            if (path instanceof Integer && destination instanceof List) {
                List destinationList = (List)destination;
                if (destinationList.size() < (Integer)path) {
                    return defaultValue;
                }
                destination = destinationList.get((Integer)path);
                continue;
            }
            throw new UnsupportedOperationException("Navigation supports only Map and List source types and non-null String and Integer path types");
        }
        return JoltUtils.cast(destination);
    }

    public static boolean isEmptyJson(Object obj) {
        Collection values = null;
        if (obj instanceof Collection) {
            if (((Collection)obj).size() == 0) {
                return true;
            }
            values = (Collection)obj;
        }
        if (obj instanceof Map) {
            if (((Map)obj).size() == 0) {
                return true;
            }
            values = ((Map)obj).values();
        }
        int processedEmpty = 0;
        if (values != null) {
            for (Object value : values) {
                if (!JoltUtils.isEmptyJson(value)) {
                    return false;
                }
                ++processedEmpty;
            }
            if (processedEmpty == values.size()) {
                return true;
            }
        }
        return false;
    }

    public static List<Object[]> listKeyChains(Object source) {
        LinkedList<Object[]> keyChainList = new LinkedList<Object[]>();
        if (source instanceof Map) {
            Map sourceMap = (Map)source;
            for (Object key : sourceMap.keySet()) {
                keyChainList.addAll(JoltUtils.listKeyChains(key, sourceMap.get(key)));
            }
        } else if (source instanceof List) {
            List sourceList = (List)source;
            for (int i = 0; i < sourceList.size(); ++i) {
                keyChainList.addAll(JoltUtils.listKeyChains(i, sourceList.get(i)));
            }
        } else {
            return Collections.emptyList();
        }
        return keyChainList;
    }

    public static List<Object[]> listKeyChains(Object key, Object value) {
        LinkedList<Object[]> keyChainList = new LinkedList<Object[]>();
        List<Object[]> childKeyChainList = JoltUtils.listKeyChains(value);
        if (childKeyChainList.size() > 0) {
            for (Object[] childKeyChain : childKeyChainList) {
                Object[] keyChain = new Object[childKeyChain.length + 1];
                keyChain[0] = key;
                System.arraycopy(childKeyChain, 0, keyChain, 1, childKeyChain.length);
                keyChainList.add(keyChain);
            }
        } else {
            keyChainList.add(new Object[]{key});
        }
        return keyChainList;
    }

    public static String toSimpleTraversrPath(Object[] paths) {
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            Object path = paths[i];
            if (path instanceof Integer) {
                pathBuilder.append("[").append((Integer)path).append("]");
            } else if (path instanceof String) {
                pathBuilder.append(path.toString());
            } else {
                throw new UnsupportedOperationException("Only Strings and Integers are supported as path element");
            }
            if (i + 1 == paths.length) continue;
            pathBuilder.append(".");
        }
        return pathBuilder.toString();
    }

    public static <T> T cast(Object object) {
        return (T)object;
    }

    public static <E> E[] cast(Object[] object) {
        return object;
    }
}

