/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt;

import com.bazaarvoice.jolt.Transform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Sortr
implements Transform {
    private static final JsonKeyComparator jsonKeyComparator = new JsonKeyComparator();

    @Override
    public Object transform(Object input) {
        return Sortr.sortJson(input);
    }

    public static Object sortJson(Object obj) {
        if (obj instanceof Map) {
            return Sortr.sortMap((Map)obj);
        }
        if (obj instanceof List) {
            return Sortr.ordered((List)obj);
        }
        return obj;
    }

    private static Map<String, Object> sortMap(Map<String, Object> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys, jsonKeyComparator);
        LinkedHashMap<String, Object> orderedMap = new LinkedHashMap<String, Object>(map.size());
        for (String key : keys) {
            orderedMap.put(key, Sortr.sortJson(map.get(key)));
        }
        return orderedMap;
    }

    private static List<Object> ordered(List<Object> list) {
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (Object obj : list) {
            newList.add(Sortr.sortJson(obj));
        }
        return newList;
    }

    private static class JsonKeyComparator
    implements Comparator<String> {
        private JsonKeyComparator() {
        }

        @Override
        public int compare(String a, String b) {
            boolean bTilde;
            boolean aTilde = a.charAt(0) == '~';
            boolean bl = bTilde = b.charAt(0) == '~';
            if (aTilde && !bTilde) {
                return -1;
            }
            if (!aTilde && bTilde) {
                return 1;
            }
            return a.compareTo(b);
        }
    }
}

