/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.cardinality;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.AtPathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.common.pathelement.PathElement;
import com.bazaarvoice.jolt.common.pathelement.StarAllPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarRegexPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarSinglePathElement;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.utils.StringTools;
import java.util.Arrays;
import java.util.List;

public abstract class CardinalitySpec {
    private static final String STAR = "*";
    private static final String AT = "@";
    protected final MatchablePathElement pathElement;

    public CardinalitySpec(String rawJsonKey) {
        List<PathElement> pathElements = CardinalitySpec.parse(rawJsonKey);
        if (pathElements.size() != 1) {
            throw new SpecException("CardinalityTransform invalid LHS:" + rawJsonKey + " can not contain '.'");
        }
        PathElement pe = pathElements.get(0);
        if (!(pe instanceof MatchablePathElement)) {
            throw new SpecException("Spec LHS key=" + rawJsonKey + " is not a valid LHS key.");
        }
        this.pathElement = (MatchablePathElement)pe;
    }

    public static List<PathElement> parse(String key) {
        if (key.contains(AT)) {
            return Arrays.asList(new AtPathElement(key));
        }
        if (STAR.equals(key)) {
            return Arrays.asList(new StarAllPathElement(key));
        }
        if (key.contains(STAR)) {
            if (StringTools.countMatches(key, STAR) == 1) {
                return Arrays.asList(new StarSinglePathElement(key));
            }
            return Arrays.asList(new StarRegexPathElement(key));
        }
        return Arrays.asList(new LiteralPathElement(key));
    }

    public abstract boolean apply(String var1, Object var2, WalkedPath var3, Object var4);
}

