/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common.pathelement;

import com.bazaarvoice.jolt.common.WalkedPath;
import com.bazaarvoice.jolt.common.pathelement.BasePathElement;
import com.bazaarvoice.jolt.common.pathelement.EvaluatablePathElement;
import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.common.reference.AmpReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AmpPathElement
extends BasePathElement
implements MatchablePathElement,
EvaluatablePathElement {
    private final List<Object> tokens;
    private final String canonicalForm;

    public AmpPathElement(String key) {
        super(key);
        StringBuilder literal = new StringBuilder();
        StringBuilder canonicalBuilder = new StringBuilder();
        ArrayList<Object> tok = new ArrayList<Object>();
        for (int index = 0; index < key.length(); ++index) {
            char c = key.charAt(index);
            if (c == '&') {
                if (literal.length() > 0) {
                    tok.add(literal.toString());
                    canonicalBuilder.append((CharSequence)literal);
                    literal = new StringBuilder();
                }
                int refEnd = AmpPathElement.findEndOfReference(key.substring(index + 1));
                AmpReference ref = new AmpReference(key.substring(index, index + refEnd + 1));
                canonicalBuilder.append(ref.getCanonicalForm());
                tok.add(ref);
                index += refEnd;
                continue;
            }
            literal.append(c);
        }
        if (literal.length() > 0) {
            tok.add(literal.toString());
        }
        tok.trimToSize();
        this.tokens = Collections.unmodifiableList(tok);
        this.canonicalForm = canonicalBuilder.toString();
    }

    private static int findEndOfReference(String key) {
        if ("".equals(key)) {
            return 0;
        }
        for (int index = 0; index < key.length(); ++index) {
            char c = key.charAt(index);
            if (Character.isDigit(c) || c == '(' || c == ')' || c == ',') continue;
            return index;
        }
        return key.length();
    }

    @Override
    public String getCanonicalForm() {
        return this.canonicalForm;
    }

    public List<Object> getTokens() {
        return this.tokens;
    }

    @Override
    public String evaluate(WalkedPath walkedPath) {
        StringBuilder output = new StringBuilder();
        for (Object token : this.tokens) {
            if (token instanceof String) {
                output.append(token);
                continue;
            }
            AmpReference ref = (AmpReference)token;
            LiteralPathElement literalPathElement = walkedPath.elementFromEnd(ref.getPathIndex()).getLiteralPathElement();
            String value = literalPathElement.getSubKeyRef(ref.getKeyGroup());
            output.append(value);
        }
        return output.toString();
    }

    @Override
    public LiteralPathElement match(String dataKey, WalkedPath walkedPath) {
        String evaled = this.evaluate(walkedPath);
        if (evaled.equals(dataKey)) {
            return new LiteralPathElement(evaled);
        }
        return null;
    }
}

